package com.biz.crm.approval.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.approval.mapper.MdmApprovalConfigSubmitterMapper;
import com.biz.crm.approval.model.MdmApprovalConfigSubmitterEntity;
import com.biz.crm.approval.service.MdmApprovalConfigSubmitterService;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigSubmitterReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigSubmitterRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 审批配置提交人信息表实体类接口实现
 *
 * @author Tao.Chen
 * @date 2021-04-28 11:29:26
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmApprovalConfigSubmitterServiceExpandImpl")
public class MdmApprovalConfigSubmitterServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmApprovalConfigSubmitterMapper, MdmApprovalConfigSubmitterEntity> implements MdmApprovalConfigSubmitterService {

    @Resource
    private MdmApprovalConfigSubmitterMapper mdmApprovalConfigSubmitterMapper;

    @Override
    public List<MdmApprovalConfigSubmitterRespVo> findSubmitterList(String businessCode) {
        Assert.hasText(businessCode, "缺失业务编码");
        List<MdmApprovalConfigSubmitterEntity> list = this.lambdaQuery()
                .eq(MdmApprovalConfigSubmitterEntity::getBusinessCode, businessCode)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return CrmBeanUtil.copyList(list, MdmApprovalConfigSubmitterRespVo.class);
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveSubmitterList(String businessCode, List<MdmApprovalConfigSubmitterReqVo> conditionList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(conditionList)) {
            Assert.hasText(businessCode, "缺失业务编码");
            List<MdmApprovalConfigSubmitterEntity> collect = conditionList.stream().map(x -> {
                MdmApprovalConfigSubmitterEntity copy = CrmBeanUtil.copy(x, MdmApprovalConfigSubmitterEntity.class);
                copy.setBusinessCode(businessCode);
                return copy;
            }).collect(Collectors.toList());
            this.saveBatch(collect);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSubmitterList(String businessCode) {
        Assert.hasText(businessCode, "缺失业务编码");
        this.lambdaUpdate()
                .eq(MdmApprovalConfigSubmitterEntity::getBusinessCode, businessCode)
                .remove();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSubmitterList(List<String> businessCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(businessCodeList)) {
            this.lambdaUpdate()
                    .in(MdmApprovalConfigSubmitterEntity::getBusinessCode, businessCodeList)
                    .remove();
        }
    }

}
