package com.biz.crm.availablelist.consumer;

import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.utils.AvailableUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Description: 刷新终端可购清单消息消费者
 * @Author: zhangyuzhu
 * @Date: 2020/10/30 14:18
 **/
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.TERMINAL_AVAILBLELIST_REFRSH,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.TERMINAL_AVAILBLELIST_REFRSH + "${rocketmq.environment-variable}")
public class TerminalAvailableListRefreshConsumer extends AbstractRocketMQConsumer {

    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;

    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        log.info("处理刷新可够清单开始---------------");
        String msg = message.getMsgBody();
        if(StringUtils.isEmpty(msg)){
            log.info("消息为空");
            return "消息为空!";
        }
        log.info("消息体：{}",msg);
        List<String> terminalCodes = JsonPropertyUtil.toObject(msg,List.class);
        if(CollectionUtils.isEmpty(terminalCodes)){
            log.info("客户列表为空!");
            return "客户列表为空!";
        }
        terminalAvailablelistService.reFresh(terminalCodes);
        log.info("处理刷新可够清单结束---------------");
        return "操作成功";
    }
}
