package com.biz.crm.availablelist.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**可购清单
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:47
 **/
@Api(value = "管理端-可购清单", tags = "管理端-可购清单")
@RestController
@RequestMapping("/m/availableList")
public class AvailableListmController {

    @Resource
    private CusAvailablelistService cusAvailablelistService;

    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;


    @CrmLog
    @ApiOperation(value = "批量刷新客户可购清单")
    @PostMapping(value = "reFresh/cus")
    public Result<Object> reFreshCus(@RequestBody ArrayList<String> cusCodes) {
        cusAvailablelistService.reFresh(cusCodes);
        return Result.ok();
    }


    @CrmLog
    @ApiOperation(value = "批量刷新客户可购清单")
    @PostMapping(value = "reFresh/promotionFlag")
    public Result<Object> reFreshPromotionFlag(@RequestBody ArrayList<String> cusCodes) {
        cusAvailablelistService.reFreshPromotion(cusCodes);
        return Result.ok();
    }


    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "查询客户可购清单")
    @PostMapping(value = "list")
    public Result<PageResult<CusAvailablelistVo>> list(@RequestBody CusAvailablelistVo cusAvailablelistVo) {
        return Result.ok(cusAvailablelistService.listForM(cusAvailablelistVo));
    }


    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "根据id删除客户可购清单")
    @GetMapping(value = "delById/{id}")
    public Result<Object> delById(@PathVariable("id") String id) {
        cusAvailablelistService.delById(id);
        return Result.ok();
    }

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "根据id批量删除客户可购清单")
    @PostMapping(value = "delByIds")
    public Result<Object> delByIds(@RequestBody List<String> ids) {
        cusAvailablelistService.delByIds(ids);
        return Result.ok();
    }

//    @CrmLog
//    @CrossOrigin
//    @ApiOperation(value = "批量根据商品code删除")
//    @PostMapping(value = "delByGoodsCode")
//    public Result<Object> delByGoodsCode(@RequestParam("goodsCode") List<String> goodsCodes) {
//        cusAvailablelistService.delByGoodsCodes(goodsCodes);
//        return Result.ok();
//    }
//
//
//    @CrmLog
//    @CrossOrigin
//    @ApiOperation(value = "批量跟新商品数据")
//    @PostMapping(value = "updateByGoodsCodes")
//    public Result<Object> updateByGoodsCodes(@RequestBody List<MdmProductAdviseRespVo> mdmProductAdviseRespVos) {
//        cusAvailablelistService.updateByGoodsCodes(mdmProductAdviseRespVos);
//        return Result.ok();
//    }

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "根据商品查询客户可购清单")
    @PostMapping(value = "findGoodsByCusAndGoodsCodes")
    public Result<Map<String, CusAvailablelistVo>> findGoodsByCusAndGoodsCodes(@RequestBody List<String> goodsCodes, @RequestParam("cusCode") String cusCode) {
        return Result.ok(cusAvailablelistService.findGoodsByCusAndGoodsCodes(goodsCodes,cusCode));
    }


    @CrmLog
    @ApiOperation(value = "通过id查询客户可购清单")
    @GetMapping(value = "findById/{id}")
    public Result<CusAvailablelistVo> findById(@PathVariable("id") String id) {
        return Result.ok(cusAvailablelistService.findById(id));
    }
}
