package com.biz.crm.availablelist.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.utils.CusAvailablelistUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**可够清单规则
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:47
 **/
@Api(value = "微信-可够清单-客户", tags = "微信-客户-可够清单-客户")
@RestController
@RequestMapping("/v/cus/availableList")
public class AvailableListvController {

    @Resource
    private CusAvailablelistService cusAvailablelistService;


    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "查询当前客户可够清单")
    @PostMapping(value = "list")
    public Result<PageResult<CusAvailablelistVo>> list(@RequestBody CusAvailablelistVo cusAvailablelistVo) {
        cusAvailablelistVo.setCusCode(UserUtils.getUser().getCustcode());
        cusAvailablelistVo.setIsShelf(YesNoEnum.yesNoEnum.YES.getValue());
        return Result.ok(cusAvailablelistService.list(cusAvailablelistVo));
    }


    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "添加商品到常购清单")
    @PostMapping(value = "ofenByfictitiousIds")
    public Result<Object> ofenByfictitiousIds(@RequestBody List<String> ids) {
        cusAvailablelistService.ofenIds(ids, YesNoEnum.YesNoCodeNumberEnum.YES,UserUtils.getUser().getCustcode());
        return Result.ok();
    }

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "删除常购清单")
    @PostMapping(value = "reMoveOfenByfictitiousIds")
    public Result<Object> reMoveOfenByfictitiousIds(@RequestBody List<String> ids) {
        cusAvailablelistService.ofenIds(ids, YesNoEnum.YesNoCodeNumberEnum.NO,UserUtils.getUser().getCustcode());
        return Result.ok();
    }

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "根据商品goodsCode查询商品详情(隐含了cusCode,key{goods:商品信息；promotion：促销信息})")
    @GetMapping(value = "findGoodsDetailByCode/{goodsCode}")
    public Result<CusAvailablelistVo> findGoodsDetailByCode(@PathVariable("goodsCode") String goodsCode) {
        return Result.ok(cusAvailablelistService.findGoodsDetailByCode(goodsCode,UserUtils.getUser().getCustcode()));
    }
}
