package com.biz.crm.availablelist.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.availablelist.TerminalAvailablelistVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**可购清单规则
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:47
 **/
@Api(value = "api-终端可购清单", tags = "api-终端可购清单")
@RestController
@RequestMapping("/api/terminal/availableList")
public class TerminalAvailableListApiController {

    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "查询终端可购清单")
    @PostMapping(value = "terminal/list")
    public Result<PageResult<TerminalAvailablelistVo>> listTerminal(@RequestBody TerminalAvailablelistVo terminalAvailablelistVo) {
        return Result.ok(terminalAvailablelistService.list(terminalAvailablelistVo));
    }
}
