package com.biz.crm.availablelist.entity;

import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.utils.MdmConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Document;


/**
 * @Description: 客户可够清单列表
 * 当前类没有添加50个拓展字段，如果项目上需要用到拓展字段，请自行在该类添加，请务必注意不要跟现有的拓展字段重复
 * @Author: zhangyuzhu
 * @Date: 2020/10/9 14:40
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Document(indexName= MdmConstant.ES_CUSAVAILABLELIST_INDEXNAME, refreshInterval = "300s",type=MdmConstant.ES_CUSAVAILABLELIST_TYPE,createIndex = false)
public class CusAvailablelistEntity extends MdmProductAdviseRespVo {

    /**
     * 客户编码
     */
    private String cusCode;

    /**
     * 客户名称
     */
    private String cusName;

    /**
     * 客户所属组织编码
     */
    private String cusOrgCode;

    /**
     * 客户所属组织名称
     */
    private String cusOrgName;

    /**
     * 客户所属渠道编码
     */
    private String cusChannelCode;

    /**
     * 客户所属渠道名称
     */
    private String cusChannelName;

    /**
     * 是否常购
     */
    private Integer ofenFlag;


    /**
     * 当前是否享受促销
     */
    private Integer promotionFlag;

    /**
     * 客户信息(拓展用)
     */
    private MdmCustomerMsgRespVo cus;

    /**
     * 可购规则编码
     */
    private String availableRuleCode;
}
