package com.biz.crm.availablelist.repositories;

import com.biz.crm.availablelist.entity.CusAvailablelistEntity;
import org.springframework.data.repository.CrudRepository;

import java.util.List;

/**
 * @Author zhangyuzhu
 * @Description
 * @Created data 2019/7/11 11:56
 */
public interface CusAvailablelistRepositories extends CrudRepository<CusAvailablelistEntity, String> {

    /**
     * 根据商品code查询
     * @param productCodes
     * @return
     */
    List<CusAvailablelistEntity> findByProductCodeInAndCusCode(List<String> productCodes,String cusCode);
    /**
     * 根据商品code列表删除
     * @param productCodes
     */
    void deleteByCusCodeAndProductCodeIn(String cusCode,List<String> productCodes);

    /**
     * 查询某位客户的常购清单
     * @param cusCode
     * @param ofenFlag
     * @return
     */
    List<CusAvailablelistEntity> findByCusCodeAndOfenFlag(String cusCode,Integer ofenFlag);


    /**
     * 根据客户code和商品codes查询商品信息
     * @param cusCode
     * @param productCodes
     * @return
     */
    List<CusAvailablelistEntity> findByCusCodeAndProductCodeIn(String cusCode,List<String> productCodes);

    /**
     * 根据客户code和商品code查询商品信息
     * @param cusCode
     * @param productCode
     * @return
     */
    List<CusAvailablelistEntity> findByCusCodeAndProductCode(String cusCode,String productCode);


    /**
     * 根据id批量查询
     * @param ids
     * @return
     */
    List<CusAvailablelistEntity> findByIdIn(List<String> ids);

    /**
     * 根据id批量删除
     * @param ids
     */
    void deleteByIdIn(List<String> ids);


    /**
     * 根据客户code查询客户的所有可够商品清单
     * @param cusCode
     * @return
     */
    List<CusAvailablelistEntity> findByCusCode(String cusCode);

    /**
     * 根据商品code查询
     * @param productCodes
     * @return
     */
    List<CusAvailablelistEntity> findByProductCodeIn(List<String> productCodes);
}
