package com.biz.crm.availablelist.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.availablelist.AvalibleListProductLevelChangeDto;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;

import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/10/9 15:01
 **/
public interface CusAvailablelistService {

    /**
     *  刷新客户可够清单（如果没有则添加，有则替换）
     * @param goods 商品列表
     * @param cusCode 客户编码
     */
    void reFresh(List<MdmProductAdviseRespVo> goods,String cusCode);

    /**
     *  刷新客户可够清单
     * @param cusCode 客户code
     */
    void reFresh(String cusCode);

    /**
     *  同步新增的客户可够清单（如果没有则添加，有则替换）
     * @param goods 商品列表
     * @param cusCode 客户编码
     */
    void syncCusAvailableList(List<MdmProductAdviseRespVo> goods,String cusCode,String ruleCode);

    /**
     *  同步新增的客户可够清单（如果没有则添加，有则替换）
     * @param goods 商品列表
     * @param cusCode 客户编码
     */
    void editSyncCusAvailableList(List<MdmProductAdviseRespVo> goods,String cusCode,String ruleCode);



    /**
     *  批量刷新客户可够清单
     * @param cusCodes 客户code列表
     */
    void reFresh(List<String> cusCodes);


    /**
     * 刷新客户可够清单的促销标志
     * @param cusCode
     */
    void reFreshPromotion(String cusCode);

    /**
     * 批量刷新客户可够清单的促销标志
     * @param cusCodes
     */
    void reFreshPromotion(List<String> cusCodes);

    /**
     * 根据产品层级刷新可够清单
     * @param productLevelCode
     */
    void reFreshByProductLevel(List<String> productLevelCode);

    /**
     * 修改商品的层级信息
     * @param dtoMap key->商品编码
     */
    void reFreshProductLevel(Map<String,AvalibleListProductLevelChangeDto> dtoMap);

    /**
     * 根据客户编码修改商品的层级信息(reFreshProductLevel 专用)
     * @param cusCode
     * @param dtoMap
     */
    void reFreshProductLevelByCus(String cusCode,Map<String,AvalibleListProductLevelChangeDto> dtoMap);

    /**
     * 根据商品codes更新商品信息
     * @param mdmProductAdviseRespVos
     */
    void updateByGoodsCodes(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos);

    /**
     * 更新客户可够清单(updateByGoodsCodes方法专用)
     * @param mdmProductAdviseRespVos
     * @param cusCode
     */
    void updateGoodsByCusCode(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos,String cusCode);


    /**
     * 根据商品code删除可够清单
     * @param goodsCodes
     */
    void delByGoodsCodes(List<String> goodsCodes);


    /**
     * 根据商品code删除可够清单(delByGoodsCodes方法专用)
     * @param goodsCodes
     */
    void delByGoodsCodesAndCusCode(List<String> goodsCodes,String cusCode);

    /**
     * 查询可够商品
     * @return
     */
    PageResult<CusAvailablelistVo> listForM(CusAvailablelistVo cusAvailablelistVo);


    /**
     * 查询可够商品
     * @return
     */
    PageResult<CusAvailablelistVo> list(CusAvailablelistVo cusAvailablelistVo);

    /**
     * 根据id删除
     * @param id
     */
    void delById(String id);

    /**
     * 根据id删除(delById方法专用)
     * @param id
     * @param cusCode
     */
    void delByIdAndCusCode(String id,String cusCode);

    /**
     * 根据id批量删除
     * @param ids
     */
    void delByIds(List<String> ids);

    /**
     * 根据id批量删除(delByIds方法专用)
     * @param ids
     */
    void delByIdsAndCusCode(List<String> ids,String cusCode);

    /**
     * 添加/删除商品到常购清单
     * @param ids
     */
    void ofenIds(List<String> ids, YesNoEnum.YesNoCodeNumberEnum ofenflag, String cusCode);

    /**
     * 根据客户code和商品code列表查询商品信息，如果没有查询到商品 商品值为null
     * @param goodsCodes
     * @param cusCode
     * @return
     */
    Map<String, CusAvailablelistVo> findGoodsByCusAndGoodsCodes(List<String> goodsCodes, String cusCode);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    CusAvailablelistVo findById(String id);


    /**
     * 根据客户code和商品code查询商品详情和促销信息
     * @param goodsCode
     * @param cusCode
     * @return key{goods:商品信息；promotion：促销信息}
     */
    Map<String,Object> findGoodsDetailAndPromotionByCode(String goodsCode,String cusCode);


    /**
     * 根据客户code和商品code查询商品详情
     * @param goodsCode
     * @param cusCode
     * @return
     */
    CusAvailablelistVo findGoodsDetailByCode(String goodsCode,String cusCode);
}
