package com.biz.crm.availablelist.utils;

import com.biz.crm.availablelist.entity.CusAvailablelistEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.UUIDGenerator;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/10/9 16:17
 **/
public class CusAvailablelistUtil {

    /**
     * 组装实体类
     * @param goodsList
     * @param customerMsgRespVo
     * @param ofenGoodsCodes
     * @param promotionMap
     * @return
     */
    public static List<CusAvailablelistEntity> packageEntities(List<MdmProductAdviseRespVo> goodsList,
                                                               MdmCustomerMsgRespVo customerMsgRespVo,
                                                               List<String> ofenGoodsCodes,
                                                               Map<String, Boolean> promotionMap){
        List<CusAvailablelistEntity> reList = new ArrayList<>(goodsList.size());
        Set<String> ofens = new HashSet<>();
        if(!CollectionUtils.isEmpty(ofenGoodsCodes)){
            ofens = new HashSet<>(ofenGoodsCodes);
        }
        for(MdmProductAdviseRespVo goods : goodsList){
            CusAvailablelistEntity entity = new CusAvailablelistEntity();
            BeanUtils.copyProperties(goods,entity);
            entity.setId(UUIDGenerator.generate());
            entity.setCusCode(customerMsgRespVo.getCustomerCode());
            entity.setCusName(customerMsgRespVo.getCustomerName());
            entity.setCusOrgCode(customerMsgRespVo.getOrgCode());
            entity.setCusOrgName(customerMsgRespVo.getOrgName());
            entity.setCusChannelCode(customerMsgRespVo.getChannel());
            entity.setCusChannelName(customerMsgRespVo.getChannelName());
            entity.setOfenFlag(ofens.contains(entity.getProductCode())? YesNoEnum.YesNoCodeNumberEnum.YES.getCode():YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
            Boolean promotionFlag = promotionMap.get(entity.getProductCode());
            entity.setPromotionFlag(
                    promotionFlag == null || !promotionFlag?YesNoEnum.YesNoCodeNumberEnum.NO.getCode():YesNoEnum.YesNoCodeNumberEnum.YES.getCode()
                    );
            entity.setCus(customerMsgRespVo);
            entity.setUpdateDate(DateUtil.dateNow2Str());
            entity.setUpdateDateSecond(DateUtil.dateNowStrHms());
            reList.add(entity);
        }

        return reList;
    }

    /**
     * copy 商品vo属性
     * @param entity
     * @param vo
     * @return
     */
    public static CusAvailablelistEntity copyGoodsVo(CusAvailablelistEntity entity,MdmProductAdviseRespVo vo){
        if(null == vo){
            return entity;
        }
        String id = entity.getId();
        BeanUtils.copyProperties(vo,entity);
        entity.setId(id);
        return entity;
    }
}
