package com.biz.crm.availablelist.utils;

import com.biz.crm.availablelist.entity.TerminalAvailablelistEntity;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.UUIDGenerator;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/10/9 16:17
 **/
public class TerminalAvailablelistUtil {

    /**
     * 组装实体类
     * @param goodsList
     * @param terminalReqVo
     * @return
     */
    public static List<TerminalAvailablelistEntity> packageEntities(List<MdmProductAdviseRespVo> goodsList, MdmTerminalVo terminalReqVo){
        List<TerminalAvailablelistEntity> reList = new ArrayList<>(goodsList.size());
        for(MdmProductAdviseRespVo goods : goodsList){
            TerminalAvailablelistEntity entity = new TerminalAvailablelistEntity();
            BeanUtils.copyProperties(goods,entity);
            entity.setId(UUIDGenerator.generate());
            entity.setTerminalCode(terminalReqVo.getTerminalCode());
            entity.setTerminalName(terminalReqVo.getTerminalName());
            entity.setTerminalOrgCode(terminalReqVo.getOrgCode());
            entity.setTerminalOrgName(terminalReqVo.getOrgName());
            entity.setTerminalChannelCode(terminalReqVo.getChannel());
            entity.setTerminalChannelName(terminalReqVo.getChannelName());
            entity.setMdmTerminalVo(terminalReqVo);
            reList.add(entity);
        }
        return reList;
    }

    /**
     * copy 商品vo属性
     * @param entity
     * @param vo
     * @return
     */
    public static TerminalAvailablelistEntity copyGoodsVo(TerminalAvailablelistEntity entity, MdmProductAdviseRespVo vo){
        if(null == vo){
            return entity;
        }
        String id = entity.getId();
        BeanUtils.copyProperties(vo,entity);
        entity.setId(id);
        return entity;
    }
}
