package com.biz.crm.availablelistrule.advise;

import com.alibaba.fastjson.JSON;
import com.biz.crm.availablelistrule.advise.strategy.ChangeAdviseTargetStrategy;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.utils.AvailableUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/29 14:44
 **/
@Slf4j
@ConditionalOnMissingBean(name = "adviseExpand")
@Component(value = "advise")
public class Advise {

    @Autowired
    private RocketMQProducer rocketMQProducer;


    /**
     * 通知对象
     * @param changeAdviseTargetStrategy 查询通知目标策略类
     * @param obj 查询通知目标的查询参数
     */
    public void adviseTarget(ChangeAdviseTargetStrategy changeAdviseTargetStrategy,List obj){
        //检测可购清单刷新开关，如果为关闭状态则不刷新
        if(!AvailableUtil.refreshFlag()) {
            log.info("已禁止规则生成可够清单，请开启！");
        }

        List<String> values = changeAdviseTargetStrategy.searchTarget(obj);
        if(CollectionUtils.isEmpty(values)){
            return;
        }
        RocketMQMessageBody msg = new RocketMQMessageBody();
        msg.setTag(changeAdviseTargetStrategy.getKey());
        msg.setMsgBody(JSON.toJSONString(values));
        rocketMQProducer.convertAndSend(msg);
    }
}
