package com.biz.crm.availablelistrule.advise.strategy;

import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.mq.RocketMQConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/** 客户组织策略
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/29 15:50
 **/
@ConditionalOnMissingBean(name = "customerOrgChangeAdviseTargetStrategyExpand")
@Component(value = "customerOrgChangeAdviseTargetStrategy")
public class CustomerOrgChangeAdviseTargetStrategy implements ChangeAdviseTargetStrategy<List<String>>{

    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;

    @Override
    public List<String> searchTarget(List<String> obj) {
        if(CollectionUtils.isEmpty(obj)){
            return null;
        }
        List<String> cusCodes = mdmCustomerMsgService.findByOrgCodeList(obj);
        return cusCodes;
    }

    @Override
    public String getKey() {
        return RocketMQConstant.CRM_MQ_TAG.CUS_AVAILBLELIST_REFRSH;
    }
}
