package com.biz.crm.availablelistrule.advise.strategy;

import com.biz.crm.mq.RocketMQConstant;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 商品层级变更策略
 *
 * @author sunx
 * @date 2021/9/13
 */
@ConditionalOnMissingBean(name = "productLevelChangeAdviseTargetStrategyExpand")
@Component(value = "productLevelChangeAdviseTargetStrategy")
public class ProductLevelChangeAdviseTargetStrategy implements ChangeAdviseTargetStrategy<List<String>> {
    /**
     * 查询通知的目标,并且组装值
     *
     * @param obj
     * @return
     */
    @Override
    public List<String> searchTarget(List<String> obj) {
        return obj;
    }

    /**
     * 获取key
     *
     * @return
     */
    @Override
    public String getKey() {
        return RocketMQConstant.CRM_MQ_TAG.AVAILBLELIST_REFRSH_UPDATE_PRODUCT_LEVEL;
    }
}
