package com.biz.crm.availablelistrule.advise.strategy;

import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.terminal.service.MdmTerminalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/** 终端组织策略
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/29 15:50
 **/
@ConditionalOnMissingBean(name = "terminalOrgChangeAdviseTargetStrategyExpand")
@Component(value = "terminalOrgChangeAdviseTargetStrategy")
public class TerminalOrgChangeAdviseTargetStrategy implements ChangeAdviseTargetStrategy<List<String>>{

    @Autowired
    private MdmTerminalService mdmTerminalService;

    @Override
    public List<String> searchTarget(List<String> obj) {
        if(CollectionUtils.isEmpty(obj)){
            return null;
        }
        List<String> codes = mdmTerminalService.findByOrgCodeList(obj);
        return codes;
    }

    @Override
    public String getKey() {
        return RocketMQConstant.CRM_MQ_TAG.TERMINAL_AVAILBLELIST_REFRSH;
    }
}
