package com.biz.crm.availablelistrule.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.availablelistrule.service.AvailableListRuleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;

/**可购清单规则
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:47
 **/
@Api(value = "管理端-可购清单规则", tags = "管理端-可购清单规则")
@RestController
@RequestMapping("/m/availableList/rule")
public class AvailableListRulemController{

    @Resource
    private AvailableListRuleService availableListRuleService;


    @CrmLog
    @ApiOperation(value = "新增")
    @PostMapping(value = "add")
    public Result add(@RequestBody AvailableListRuleVo availableListRuleVo) {
        availableListRuleService.add(availableListRuleVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "新增（专属合同）")
    @PostMapping(value = "addForConstract")
    public Result addForConstract(@RequestBody AvailableListRuleVo availableListRuleVo) {
        availableListRuleService.addForConstract(availableListRuleVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "编辑")
    @PostMapping(value = "edit")
    public Result edit(@RequestBody AvailableListRuleVo availableListRuleVo) {
        availableListRuleService.edit(availableListRuleVo);
        return Result.ok();
    }


    @CrmLog
    @ApiOperation(value = "通过id查询")
    @GetMapping(value = "findById/{id}")
    public Result<AvailableListRuleVo> findById(@PathVariable("id") String id) {
        return Result.ok(availableListRuleService.findById(id));
    }

    @CrmLog
    @ApiOperation(value = "通过来源单号查询")
    @GetMapping(value = "findBySourceId/{sourceId}")
    public Result<AvailableListRuleVo> findBySourceId(@PathVariable("sourceId") String sourceId) {
        return Result.ok(availableListRuleService.findBySourceId(sourceId));
    }

    @CrmLog
    @ApiOperation(value = "分页搜索")
    @PostMapping(value = "list")
    public Result<PageResult<AvailableListRuleVo>> list(@RequestBody AvailableListRuleVo availableListRuleVo) {
        return Result.ok(availableListRuleService.list(availableListRuleVo));
    }

    @CrmLog
    @ApiOperation(value = "根据id批量删除")
    @PostMapping(value = "delByIds")
    public Result<Object> delByIds(@RequestBody ArrayList<String> ids) {
        availableListRuleService.delByIds(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "根据查询条件批量删除")
    @PostMapping(value = "delByParam")
    public Result<Object> delByParam(@RequestBody AvailableListRuleVo availableListRuleVo) {
        availableListRuleService.delByParam(availableListRuleVo);
        return Result.ok();
    }

    @CrmLog
    @ApiModelProperty(value = "根据编码批量查询是否存在")
    @PostMapping(value = "findExistByCodes")
    public Result<Map<String, Boolean>> findExistByCodes(@RequestBody List<String> codes) {
        Map<String, Boolean> result = this.availableListRuleService.findExistByCodes(codes);
        return Result.ok(result);
    }
}
