package com.biz.crm.availablelistrule.doo;

import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 查询挂在客户上的可够清单和不可够清单的do
 * @Author: zhangyuzhu
 * @Date: 2020/10/10 15:22
 **/
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AvailableDo {

    /***
     * 可够类型
     */
    private Integer type;

    /**
     * 可够商品code
     */
    private String goodsCode;

    /**
     * 产品层级code
     */
    private String productLevelCode;

    /**
     * 是否是产品层级(数据字典)
     */
    private String productLevelFlag;

    public AvailableDo() {
    }

    public Integer getType() {
        return this.type;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public AvailableDo setType(Integer type) {
        this.type = type;
        return this;
    }

    public AvailableDo setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
        return this;
    }

    public String getProductLevelCode() {
        return productLevelCode;
    }

    public AvailableDo setProductLevelCode(String productLevelCode) {
        this.productLevelCode = productLevelCode;
        return this;
    }

    public String getProductLevelFlag() {
        return productLevelFlag;
    }

    public AvailableDo setProductLevelFlag(String productLevelFlag) {
        this.productLevelFlag = productLevelFlag;
        return this;
    }

    public String toString() {
        return "AvailableDo(type=" + this.getType() + ", goodsCode=" + this.getGoodsCode() + ")";
    }
}
