package com.biz.crm.availablelistrule.handler;

import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.CustomerOrgChangeAdviseTargetStrategy;
import com.biz.crm.customer.handler.CustomerChangeHandler;
import com.biz.crm.nebular.mdm.customer.CustomerChangeHandlerReqVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Set;

/**
 * 客户信息变更规则执行刷新
 *
 * @author sunx
 * @date 2021/9/9
 */
@Component
@Slf4j
public class CustomerChangeAvailableListRuleHandler implements CustomerChangeHandler {
    @Resource
    private Advise advise;

    @Resource
    private CustomerOrgChangeAdviseTargetStrategy customerOrgChangeAdviseTargetStrategy;

    /**
     * 客户变更处理方法
     *
     * @param vo
     */
    @Override
    public void handler(CustomerChangeHandlerReqVo vo) {
        log.info("CustomerChangeAvailableListRuleHandler->handler[{}]", vo);
        Set<String> codes = Sets.newHashSet();
        if (StringUtils.isNotBlank(vo.getOldOrgCode())) {
            codes.add(vo.getOldOrgCode());
        }
        if (StringUtils.isNotBlank(vo.getCurrentOrgCode())) {
            codes.add(vo.getCurrentOrgCode());
        }
        if (CollectionUtils.isEmpty(codes)) {
            log.error("CustomerChangeAvailableListRuleHandler->handler无组织信息[{}]", vo);
            return;
        }
        advise.adviseTarget(customerOrgChangeAdviseTargetStrategy, Lists.newArrayList(codes));
    }
}
