package com.biz.crm.availablelistrule.service;

import com.biz.crm.availablelistrule.entity.AvailableListRuleEntity;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleGoodsVo;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:46
 **/
public interface AvailableListRuleGoodsService {

    /**
     * 替换掉规则商品列表
     * @param vos
     * @param ruleEntity
     */
    void replace(List<AvailableListRuleGoodsVo> vos, AvailableListRuleEntity ruleEntity);

    /**
     * 通过ruleCode查询商品列表，如果没有则返回空列表
     * @param ruleCode
     * @return
     */
    List<AvailableListRuleGoodsVo> findByRuleCode(String ruleCode);

    /**
     * 通过ruleCodes查询商品列表，如果没有则返回空列表
     * @param ruleCodes 查询条件
     * @return 查询结果
     */
    List<AvailableListRuleGoodsVo> findByRuleCodes(List<String> ruleCodes);
}
