package com.biz.crm.availablelistrule.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:46
 **/
public interface AvailableListRuleService {

    /**
     * 新增
     * @param availableListRuleVo
     */
    void add(AvailableListRuleVo availableListRuleVo);

    /**
     * 新增
     * @param availableListRuleVo
     */
    void addForConstract(AvailableListRuleVo availableListRuleVo);


    /**
     * 编辑
     * @param availableListRuleVo
     */
    void edit(AvailableListRuleVo availableListRuleVo);

    /**
     * 通过id查询对象
     * @param id
     * @return
     */
    AvailableListRuleVo findById(String id);

    /**
     * 通过来源单号查询
     * @param sourceId
     * @return
     */
    AvailableListRuleVo findBySourceId(String sourceId);

    /**
     * 分页搜索
     * @param availableListRuleVo
     * @return
     */
    PageResult<AvailableListRuleVo> list(AvailableListRuleVo availableListRuleVo);


    /**
     * 根据id批量删除或者恢复
     * @param ids
     */
    void delByIds(ArrayList<String> ids);

    /**
     * 根据查询条件批量删除
     * @param availableListRuleVo
     */
    void delByParam(AvailableListRuleVo availableListRuleVo);


    /**
     * 根据客户编码和orgCode查询可够商品（交集，去重）
     * @param cusCode
     * @param orgCodes
     * @return
     */
    List<String> findGoodsByCusCodeAndOrgCode(String cusCode,List<String> orgCodes);


    /**
     * 根据终端编码和orgCode查询可够商品（交集，去重）
     * @param terminalCode
     * @param orgCodes
     * @return
     */
    List<String> findGoodsByTerminalCodeAndOrgCode(String terminalCode,List<String> orgCodes);

    /**
     * 查询包含这些产品层级的规则【有效的】的所有客户
     * @param productLevels
     * @return 去重后的结果,如果没有则返回空集合【返回值不为null】
     */
    List<String> listCusCodesByProductLevel(List<String> productLevels);


    /**
     * 查询包含这些产品层级的规则【有效的】的所有终端
     * @param productLevels
     * @return 去重后的结果,如果没有则返回空集合【返回值不为null】
     */
    List<String> listTerminalCodesByProductLevel(List<String> productLevels);

    /**
     * 根据编码批量查询是否存在
     * @param codes
     * @return
     */
    Map<String, Boolean> findExistByCodes(List<String> codes);
}
