package com.biz.crm.availablelistrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.entity.AvailableListRuleAreaEntity;
import com.biz.crm.availablelistrule.entity.AvailableListRuleEntity;
import com.biz.crm.availablelistrule.mapper.AvailableListRuleAreaMapper;
import com.biz.crm.availablelistrule.service.AvailableListRuleAreaService;
import com.biz.crm.availablelistrule.utils.AvailableListRuleAreaUtil;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import org.assertj.core.util.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:47
 **/
@ConditionalOnMissingBean(name = "availableListRuleServiceAreaExpandImpl")
@Service(value = "availableListRuleAreaService")
public class AvailableListRuleAreaServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<AvailableListRuleAreaMapper, AvailableListRuleAreaEntity> implements AvailableListRuleAreaService {

    @Autowired
    private AvailableListRuleAreaMapper availableListRuleAreaMapper;

    /**
     * 1、删除原有商品
     * 2、组装保存
     * @param vos
     * @param ruleEntity
     */
    @Transactional
    @Override
    public void replace(List<AvailableListRuleAreaVo> vos, AvailableListRuleEntity ruleEntity) {
        //1
        this.removeByMap(new HashMap<String, Object>(){{
            put("rule_code",ruleEntity.getRuleCode());
        }});

        //2
        if(CollectionUtils.isEmpty(vos)){
            return;
        }
        this.saveBatch(AvailableListRuleAreaUtil.packageEntities(vos,ruleEntity));
    }

    @CrmDictMethod
    @Override
    public List<AvailableListRuleAreaVo> findByRuleCode(String ruleCode) {
        //1
        if(StringUtils.isEmpty(ruleCode)){
            return new ArrayList<>();
        }

        //2
        QueryWrapper<AvailableListRuleAreaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("rule_code", ruleCode);
        List<AvailableListRuleAreaEntity> goodsEntities = availableListRuleAreaMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(goodsEntities)){
            return new ArrayList<>();
        }
        List<AvailableListRuleAreaVo> reList = new ArrayList<>(goodsEntities.size());
        for(AvailableListRuleAreaEntity entity : goodsEntities){
            AvailableListRuleAreaVo vo = new AvailableListRuleAreaVo();
            BeanUtils.copyProperties(entity,vo);
            reList.add(vo);
        }
        return reList;
    }

    /**
     * 1、判断
     * 2、查询
     * @param ruleCodes
     * @return
     */
    @CrmDictMethod
    @Override
    public List<AvailableListRuleAreaVo> findByRuleCodes(List<String> ruleCodes) {
        //1
        if(CollectionUtils.isEmpty(ruleCodes)){
            return Lists.newArrayList();
        }

        //2
        return this.availableListRuleAreaMapper.findByRuleCodes(ruleCodes);
    }
}
