package com.biz.crm.availablelistrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.CustomerChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.advise.strategy.CustomerOrgChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.advise.strategy.TerminalChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.advise.strategy.TerminalOrgChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.doo.AvailableDo;
import com.biz.crm.availablelistrule.entity.AvailableListRuleEntity;
import com.biz.crm.availablelistrule.mapper.AvailableListRuleGoodsMapper;
import com.biz.crm.availablelistrule.mapper.AvailableListRuleMapper;
import com.biz.crm.availablelistrule.service.AvailableListRuleAreaService;
import com.biz.crm.availablelistrule.service.AvailableListRuleGoodsService;
import com.biz.crm.availablelistrule.service.AvailableListRuleService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.utils.ValidateUtils;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.AvailableListRuleEunm;
import com.biz.crm.eunm.mdm.AvailableListRuleEnum;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleGoodsVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.terminal.model.MdmTerminalROrgEntity;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.utils.EsSynchronismUtil;
import com.google.common.collect.Maps;
import org.assertj.core.util.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:47
 **/
@ConditionalOnMissingBean(name = "availableListRuleServiceExpandImpl")
@Service(value = "availableListRuleService")
public class AvailableListRuleServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<AvailableListRuleMapper, AvailableListRuleEntity> implements AvailableListRuleService {

    @Resource
    private AvailableListRuleMapper availableListRuleMapper;

    @Resource
    private AvailableListRuleGoodsService availableListRuleGoodsService;

    @Resource
    private AvailableListRuleAreaService availableListRuleAreaService;

    @Resource
    private CustomerChangeAdviseTargetStrategy customerChangeAdviseTargetStrategy;

    @Resource
    private CustomerOrgChangeAdviseTargetStrategy customerOrgChangeAdviseTargetStrategy;

    @Resource
    private TerminalChangeAdviseTargetStrategy terminalChangeAdviseTargetStrategy;

    @Resource
    private TerminalOrgChangeAdviseTargetStrategy terminalOrgChangeAdviseTargetStrategy;

    @Resource
    private Advise advise;

    @Autowired
    private MdmProductService mdmProductService;

    @Autowired
    private AvailableListRuleGoodsMapper availableListRuleGoodsMapper;

    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;

    @Resource
    private MdmTerminalROrgService mdmTerminalROrgService;

    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Autowired
    private EsSynchronismUtil esSynchronismUtil;


    /**
     * 1、验证
     * 2、组装保存规则
     * 3、组装保存商品列表
     * 4、组装保存区域范围信息
     * 5、通知更改
     * @param availableListRuleVo
     */
    @Transactional
    @Override
    public void add(AvailableListRuleVo availableListRuleVo) {
        //1
        ValidateUtils.validate(StringUtils.isEmpty(availableListRuleVo.getCode()),"编码不能为空!");
        ValidateUtils.validate(StringUtils.isEmpty(availableListRuleVo.getName()),"名称不能为空!");
        ValidateUtils.validate(null != availableListRuleVo.getType(),"类型不能为空!");
        ValidateUtils.validate(null != availableListRuleVo.getDimension(),"维度不能为空!");
        List<AvailableListRuleEntity> entities = availableListRuleMapper.selectByMap(new HashMap<String, Object>(){
            {
                put("code", availableListRuleVo.getCode());
            }
        });
        if(!CollectionUtils.isEmpty(entities)){
            throw new BusinessException("code重复!");
        }

        //2
        //为了不影响其他的，此处判断如果没有设置来源就是正常来源
        availableListRuleVo.setSource(
                StringUtils.isEmpty(availableListRuleVo.getSource())
                        ? AvailableListRuleEnum.SourceEunm.NOMAL.getCode():availableListRuleVo.getSource()
        );
        AvailableListRuleEntity entity = new AvailableListRuleEntity();
        BeanUtils.copyProperties(availableListRuleVo,entity);
        entity.setRuleCode(CodeUtil.createCode());
        availableListRuleMapper.insert(entity);
        Integer dimension = entity.getDimension();

        //3
        availableListRuleGoodsService.replace(availableListRuleVo.getGoods(),entity);

        //4
        availableListRuleAreaService.replace(availableListRuleVo.getAreaes(),entity);
        AvailableListRuleVo logVo =  availableListRuleVo;
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        crmLogSendUtil.sendForAdd(menuCodeObj == null ? null : menuCodeObj.toString(), entity.getId(),entity.getId(),logVo);
        //5
        List<String> codes = null;
        if(entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.CUS.getCode().intValue()){
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo :: getCusCode).collect(Collectors.toList());
        }else if(entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.CUSORG.getCode().intValue()){
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo :: getOrgCode).collect(Collectors.toList());
        }else if(entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.TERMINAL.getCode().intValue()){
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo :: getTerminalCode).collect(Collectors.toList());
        } else if(entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.TERMINALORG.getCode().intValue()){
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo :: getOrgCode).collect(Collectors.toList());
        }
        this.advise(codes, AvailableListRuleEunm.Dimension.getByCode(dimension));

        // 新增同步es
        esSynchronismUtil.addEs(availableListRuleVo,entity.getRuleCode());
    }

    @Transactional
    @Override
    public void addForConstract(AvailableListRuleVo availableListRuleVo) {
        availableListRuleVo.setCode(CodeUtil.createCode());
        availableListRuleVo.setName(new StringBuilder("合同定制规则").toString());
        availableListRuleVo.setSource(AvailableListRuleEnum.SourceEunm.CONSTRACT.getCode());
        this.add(availableListRuleVo);
    }

    /**
     * 1、验证
     * 2、组装保存商品列表
     * 3、组装保存区域范围信息
     * 4、组装更新
     * 5、通知更改
     * @param availableListRuleVo
     */
    @Transactional
    @Override
    public void edit(AvailableListRuleVo availableListRuleVo) {
        //1
        ValidateUtils.validate(StringUtils.isEmpty(availableListRuleVo.getId()),"请指定编辑的规则!");
        ValidateUtils.validate(StringUtils.isEmpty(availableListRuleVo.getName()),"名称不能为空!");
        AvailableListRuleEntity entity = availableListRuleMapper.selectById(availableListRuleVo.getId());
        ValidateUtils.validate(entity,"您要编辑的规则不存在或者已经被删除!");
        Integer dimension = entity.getDimension();
        AvailableListRuleVo oldObject = this.findById(availableListRuleVo.getId());

        //2
        availableListRuleGoodsService.replace(availableListRuleVo.getGoods(),entity);

        //3
        List<AvailableListRuleAreaVo> oldArea = availableListRuleAreaService.findByRuleCode(entity.getRuleCode());
        availableListRuleAreaService.replace(availableListRuleVo.getAreaes(),entity);

        //4
        BeanUtils.copyProperties(availableListRuleVo,entity);
        availableListRuleMapper.updateById(entity);
        //编辑日志
        AvailableListRuleVo newObject = this.findById(availableListRuleVo.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),
                entity.getId(),entity.getId(),oldObject,newObject);
        //5 因为编辑过后设计到 之前去掉的area 以及新加进来的area，所以最后变化的是 最新的area + 编辑之前的area 去重
        oldArea = CollectionUtils.isEmpty(oldArea)?new ArrayList<>():oldArea;
        List<String> oldCodes = null;//修改之前的code
        List<String> codes = null;
        if(entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.CUS.getCode().intValue()){
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo :: getCusCode).collect(Collectors.toList());
            oldCodes = oldArea.stream().map(AvailableListRuleAreaVo :: getCusCode).collect(Collectors.toList());
        }else if(entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.CUSORG.getCode().intValue()){
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo :: getOrgCode).collect(Collectors.toList());
            oldCodes = oldArea.stream().map(AvailableListRuleAreaVo :: getOrgCode).collect(Collectors.toList());
        }else if(entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.TERMINAL.getCode().intValue()){
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo :: getTerminalCode).collect(Collectors.toList());
            oldCodes = oldArea.stream().map(AvailableListRuleAreaVo :: getTerminalCode).collect(Collectors.toList());
        } else if(entity.getDimension().intValue() == AvailableListRuleEunm.Dimension.TERMINALORG.getCode().intValue()){
            codes = availableListRuleVo.getAreaes().stream().map(AvailableListRuleAreaVo :: getOrgCode).collect(Collectors.toList());
            oldCodes = oldArea.stream().map(AvailableListRuleAreaVo :: getTerminalOrgCode).collect(Collectors.toList());
        }
        Set codeSet = new HashSet();
        if(!CollectionUtils.isEmpty(codes)){
            codeSet.addAll(codes);
        }
        if(!CollectionUtils.isEmpty(oldCodes)){
            codeSet.addAll(oldCodes);
        }

        this.advise(new ArrayList<>(codeSet), AvailableListRuleEunm.Dimension.getByCode(dimension));

        // 编辑同步es
        esSynchronismUtil.editEs(availableListRuleVo);
    }

    /**
     * 1、查询主干信息
     * 2、查询商品信息
     * 3、查询区域范围信息
     * @param id
     * @return
     */
    @CrmDictMethod
    @Override
    public AvailableListRuleVo findById(String id) {
        AvailableListRuleVo vo = null;
        //1
        com.biz.crm.util.ValidateUtils.validate(id,"请指定需要查询的规则！");
        AvailableListRuleEntity entity = availableListRuleMapper.selectById(id);
        if(null == entity){
            return vo;
        }
        vo = new AvailableListRuleVo();
        BeanUtils.copyProperties(entity,vo);

        //2
        vo.setGoods(availableListRuleGoodsService.findByRuleCode(entity.getRuleCode()));

        //3
        vo.setAreaes(availableListRuleAreaService.findByRuleCode(entity.getRuleCode()));

        return vo;
    }

    /**
     * 1、查询主干信息
     * 2、查询商品信息
     * 3、查询区域范围信息
     * @param sourceId
     * @return
     */
    @Override
    public AvailableListRuleVo findBySourceId(String sourceId) {
        AvailableListRuleVo vo = null;
        //1
        if(StringUtils.isEmpty(sourceId)){
            return vo;
        }
        List<AvailableListRuleEntity> entities = availableListRuleMapper.selectByMap(new HashMap<String, Object>(){
            {
                put("source_id", sourceId);
            }
        });
        if(CollectionUtils.isEmpty(entities)){
            return vo;
        }
        AvailableListRuleEntity entity = entities.get(0);
        if(null == entity){
            return vo;
        }
        vo = new AvailableListRuleVo();
        BeanUtils.copyProperties(entity,vo);

        //2
        vo.setGoods(availableListRuleGoodsService.findByRuleCode(entity.getRuleCode()));

        //3
        vo.setAreaes(availableListRuleAreaService.findByRuleCode(entity.getRuleCode()));

        return vo;
    }

    @CrmDictMethod
    @Override
    public PageResult<AvailableListRuleVo> list(AvailableListRuleVo availableListRuleVo) {
        QueryWrapper<AvailableListRuleVo> wrapper = Wrappers.<AvailableListRuleVo>query()
                .like(!StringUtils.isEmpty(availableListRuleVo.getName()), "name", availableListRuleVo.getName())
                .like(!StringUtils.isEmpty(availableListRuleVo.getCode()), "code", availableListRuleVo.getCode())
                .eq(null != availableListRuleVo.getType(), "type", availableListRuleVo.getType())
                .eq(null != availableListRuleVo.getDimension(), "dimension", availableListRuleVo.getDimension())
                .orderByDesc("create_date", "create_date_second");
        Page<AvailableListRuleVo> page = PageUtil.buildPage(availableListRuleVo.getPageNum(), availableListRuleVo.getPageSize());
//        List<AvailableListRuleVo> list = availableListRuleMapper.list(page,wrapper);
        List<AvailableListRuleVo> list = availableListRuleMapper.findPageByConditions(page, availableListRuleVo);
        return PageResult.<AvailableListRuleVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 1、删除
     * 2、发送变动通知
     * @param ids
     */
    @Transactional
    @Override
    public void delByIds(ArrayList<String> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        List<AvailableListRuleEntity> rules = availableListRuleMapper.selectBatchIds(ids);
        if(CollectionUtils.isEmpty(rules)){
            return;
        }

        List<String> ruleCodes = rules.stream().map(AvailableListRuleEntity :: getRuleCode).collect(Collectors.toList());
        List<AvailableListRuleAreaVo> areaVos = availableListRuleAreaService.findByRuleCodes(ruleCodes);
        List<AvailableListRuleVo> ruleVos = this.findByIds(ids);
        //1
        availableListRuleMapper.deleteBatchIds(ids);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for(AvailableListRuleVo logVo : ruleVos){
            crmLogSendUtil.sendForDel(menuCodeObj.toString(),
                    logVo.getId(),logVo.getId(),logVo);
        }
        //2
        this.delAdvise(areaVos,rules);
    }

    /**
     * 1、删除
     * 2、变动通知
     * @param availableListRuleVo
     */
    @Transactional
    @Override
    public void delByParam(AvailableListRuleVo availableListRuleVo) {
        if(null == availableListRuleVo){
            throw new BusinessException("请指定查询条件!");
        }
        //1
        QueryWrapper<AvailableListRuleEntity> wrapper = Wrappers.<AvailableListRuleEntity>query()
                .like(!StringUtils.isEmpty(availableListRuleVo.getName()), "name", availableListRuleVo.getName())
                .eq(null != availableListRuleVo.getCode(), "code", availableListRuleVo.getCode())
                .eq(null != availableListRuleVo.getType(), "type", availableListRuleVo.getType());
        List<AvailableListRuleEntity> rules = availableListRuleMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(rules)){
            return;
        }
        List<AvailableListRuleAreaVo> areaVos = availableListRuleAreaService.findByRuleCodes(rules.stream().map(AvailableListRuleEntity :: getRuleCode).collect(Collectors.toList()));
        availableListRuleMapper.delete(wrapper);

        //2
        this.delAdvise(areaVos,rules);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<String> ids = rules.stream().map(entity -> entity.getId()).collect(Collectors.toList());
        List<AvailableListRuleVo> ruleVos = this.findByIds(ids);
        for(AvailableListRuleVo logVo : ruleVos){
            crmLogSendUtil.sendForDel(menuCodeObj.toString(),
                    logVo.getId(),logVo.getId(),logVo);
        }
    }

    /**
     * 1、查询挂在客户和客户组织上的可够清单和不可够清单
     * 2、可够清单 - 不可够清单，并且去重
     * @param cusCode
     * @param orgCodes
     * @return
     */
    @Override
    public List<String> findGoodsByCusCodeAndOrgCode(String cusCode, List<String> orgCodes) {
        List<String> reList = new ArrayList<>();
        //1
        List<AvailableDo> availableDos = availableListRuleGoodsMapper.findGoodsByCusCodeAndOrgCode(cusCode,orgCodes,
                AvailableListRuleEunm.Dimension.CUS.getCode(),
                AvailableListRuleEunm.Dimension.CUSORG.getCode());
        if(CollectionUtils.isEmpty(availableDos)){
            return reList;
        }

        //2
        //将产品层级筛选出来
        //包含的产品层级
        List<AvailableDo> containLevels = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue() && !StringUtils.isEmpty(vo.getProductLevelFlag()) && vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.YES.getValue()))
                .collect(Collectors.toList());
        //非包含的产品层级
        List<AvailableDo> nonContainLevels = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue() && !StringUtils.isEmpty(vo.getProductLevelFlag()) && vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.YES.getValue()))
                .collect(Collectors.toList());
        //分别将其产品code查询出来
        List<String> containLevelsProductCode = new ArrayList<>();
        List<String> nonContainLevelsProductCode = new ArrayList<>();
        if(!CollectionUtils.isEmpty(containLevels)){
            List<MdmProductRespVo> products = mdmProductService.queryBatchByProductLevelCodeList(
                    containLevels.stream().map(AvailableDo :: getProductLevelCode).collect(Collectors.toList())
            );
            if(!CollectionUtils.isEmpty(products)){
                containLevelsProductCode = products.stream().map(MdmProductRespVo :: getProductCode).collect(Collectors.toList());
            }
        }
        if(!CollectionUtils.isEmpty(nonContainLevels)){
            List<MdmProductRespVo> products = mdmProductService.queryBatchByProductLevelCodeList(
                    nonContainLevels.stream().map(AvailableDo :: getProductLevelCode).collect(Collectors.toList())
            );
            if(!CollectionUtils.isEmpty(products)){
                nonContainLevelsProductCode = products.stream().map(MdmProductRespVo :: getProductCode).collect(Collectors.toList());
            }
        }

        availableDos = availableDos.stream().filter(vo -> StringUtils.isEmpty(vo.getProductLevelFlag()) || vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.NO.getValue()))
                .collect(Collectors.toList());
        Set<String> availbleList = availableDos.stream()
                .filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue())
                .map(AvailableDo:: getGoodsCode)
                .collect(Collectors.toSet());
        availbleList.addAll(containLevelsProductCode);
        Set<String> noAvailbleList = availableDos.stream()
                .filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue())
                .map(AvailableDo:: getGoodsCode)
                .collect(Collectors.toSet());
        noAvailbleList.addAll(nonContainLevelsProductCode);
        for(String goodsCode : availbleList){
            if(!noAvailbleList.contains(goodsCode)){
                reList.add(goodsCode);
            }
        }
        return reList;
    }

    /**
     * 1、查询挂在客户和客户组织上的可够清单和不可够清单
     * 2、可够清单 - 不可够清单，并且去重
     * @param terminalCode
     * @param orgCodes
     * @return
     */
    @Override
    public List<String> findGoodsByTerminalCodeAndOrgCode(String terminalCode,List<String> orgCodes) {
        List<String> reList = new ArrayList<>();
        //1
        List<AvailableDo> availableDos = availableListRuleGoodsMapper.findGoodsByTerminalCodeAndOrgCode(terminalCode,orgCodes,
                AvailableListRuleEunm.Dimension.TERMINAL.getCode(),
                AvailableListRuleEunm.Dimension.TERMINALORG.getCode());
        if(CollectionUtils.isEmpty(availableDos)){
            return reList;
        }

        //2
        //将产品层级筛选出来
        //包含的产品层级
        List<AvailableDo> containLevels = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue() && !StringUtils.isEmpty(vo.getProductLevelFlag()) && vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.YES.getValue()))
                .collect(Collectors.toList());
        //非包含的产品层级
        List<AvailableDo> nonContainLevels = availableDos.stream().filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue() && !StringUtils.isEmpty(vo.getProductLevelFlag()) && vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.YES.getValue()))
                .collect(Collectors.toList());
        //分别将其产品code查询出来
        List<String> containLevelsProductCode = new ArrayList<>();
        List<String> nonContainLevelsProductCode = new ArrayList<>();
        if(!CollectionUtils.isEmpty(containLevels)){
            List<MdmProductRespVo> products = mdmProductService.queryBatchByProductLevelCodeList(
                    containLevels.stream().map(AvailableDo :: getProductLevelCode).collect(Collectors.toList())
            );
            if(!CollectionUtils.isEmpty(products)){
                containLevelsProductCode = products.stream().map(MdmProductRespVo :: getProductCode).collect(Collectors.toList());
            }
        }
        if(!CollectionUtils.isEmpty(nonContainLevels)){
            List<MdmProductRespVo> products = mdmProductService.queryBatchByProductLevelCodeList(
                    nonContainLevels.stream().map(AvailableDo :: getProductLevelCode).collect(Collectors.toList())
            );
            if(!CollectionUtils.isEmpty(products)){
                nonContainLevelsProductCode = products.stream().map(MdmProductRespVo :: getProductCode).collect(Collectors.toList());
            }
        }
        availableDos = availableDos.stream().filter(vo -> StringUtils.isEmpty(vo.getProductLevelFlag()) || vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.NO.getValue()))
                .collect(Collectors.toList());
        Set<String> availbleList = availableDos.stream()
                .filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue())
                .map(AvailableDo:: getGoodsCode)
                .collect(Collectors.toSet());
        availbleList.addAll(containLevelsProductCode);
        Set<String> noAvailbleList = availableDos.stream()
                .filter(vo -> vo.getType().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue())
                .map(AvailableDo:: getGoodsCode)
                .collect(Collectors.toSet());
        noAvailbleList.addAll(nonContainLevelsProductCode);
        for(String goodsCode : availbleList){
            if(!noAvailbleList.contains(goodsCode)){
                reList.add(goodsCode);
            }
        }
        return reList;
    }

    /**
     * 1、查询包含这些产品层级的有效规则
     * 2、查询这些规则包含的客户code
     * 3、将客户类型去重，将组织区分开
     * @param productLevels
     * @return
     */
    @Override
    public List<String> listCusCodesByProductLevel(List<String> productLevels) {
        if(CollectionUtils.isEmpty(productLevels)){
            return new ArrayList<>();
        }
        //1
        List<String> ruleCodes = availableListRuleGoodsMapper.findRuleCodesByProductLevels(productLevels,
                AvailableListRuleEunm.Dimension.getCusTypeCodes(),
                YesNoEnum.yesNoEnum.YES.getValue());
        if(CollectionUtils.isEmpty(ruleCodes)){
            return new ArrayList<>();
        }

        //2 为防止过多 mysql的in数量过大，所以在这里用分页的方式查询,每次1000个
        List<AvailableListRuleAreaVo> areaVos = new ArrayList<>();
        List<String> param = new ArrayList<>(500);
        for(int i = 1;i <= ruleCodes.size();i++){
            param.add(ruleCodes.get(i - 1));
            if(i % 1000 == 0 || i == ruleCodes.size()){
                List<AvailableListRuleAreaVo> vos = availableListRuleAreaService.findByRuleCodes(param);
                if(!CollectionUtils.isEmpty(vos)){
                    areaVos.addAll(vos);
                }
                param.clear();
            }
        }
        if(CollectionUtils.isEmpty(areaVos)){
            return new ArrayList<>();
        }

        //3
        //客户code
        Set<String> cusCodes = areaVos.stream()
                .filter(vo -> !StringUtils.isEmpty(vo.getCusCode())).map(AvailableListRuleAreaVo :: getCusCode)
                .collect(Collectors.toSet());
        //客户组织code
        List<String> cusOrgVos = areaVos.stream()
                .filter(vo -> StringUtils.isEmpty(vo.getCusCode())).map(AvailableListRuleAreaVo :: getOrgCode)
                .collect(Collectors.toList());
        if(CollectionUtils.isEmpty(cusOrgVos)){
            return CollectionUtils.isEmpty(cusCodes)?new ArrayList<>():new ArrayList<>(cusCodes);
        }
        List<String> cusCodesFromOrg = mdmCustomerMsgService.findByOrgCodeList(cusOrgVos);
        if(!CollectionUtil.listEmpty(cusCodesFromOrg)){
            cusCodes.addAll(cusCodesFromOrg);
        }
        return CollectionUtils.isEmpty(cusCodes)?new ArrayList<>():new ArrayList<>(cusCodes);
    }

    /**
     * 1、查询包含这些产品层级的有效规则
     * 2、查询这些规则包含的终端code
     * 3、将终端类型去重，将组织区分开
     * @param productLevels
     * @return
     */
    @Override
    public List<String> listTerminalCodesByProductLevel(List<String> productLevels) {
        if(CollectionUtils.isEmpty(productLevels)){
            return new ArrayList<>();
        }
        //1
        List<String> ruleCodes = availableListRuleGoodsMapper.findRuleCodesByProductLevels(productLevels,
                AvailableListRuleEunm.Dimension.getTerminalTypeCodes(),
                YesNoEnum.yesNoEnum.YES.getValue());
        if(CollectionUtils.isEmpty(ruleCodes)){
            return new ArrayList<>();
        }

        //2 为防止过多 mysql的in数量过大，所以在这里用分页的方式查询,每次1000个
        List<AvailableListRuleAreaVo> areaVos = new ArrayList<>();
        List<String> param = new ArrayList<>(500);
        for(int i = 1;i <= ruleCodes.size();i++){
            param.add(ruleCodes.get(i - 1));
            if(i % 1000 == 0 || i == ruleCodes.size()){
                List<AvailableListRuleAreaVo> vos = availableListRuleAreaService.findByRuleCodes(param);
                if(!CollectionUtils.isEmpty(vos)){
                    areaVos.addAll(vos);
                }
                param.clear();
            }
        }
        if(CollectionUtils.isEmpty(areaVos)){
            return new ArrayList<>();
        }

        //3
        //客户code
        Set<String> terminalCodes = areaVos.stream()
                .filter(vo -> !StringUtils.isEmpty(vo.getTerminalCode())).map(AvailableListRuleAreaVo :: getTerminalCode)
                .collect(Collectors.toSet());
        //客户组织code
        List<String> terminalOrgVos = areaVos.stream()
                .filter(vo -> StringUtils.isEmpty(vo.getTerminalCode())).map(AvailableListRuleAreaVo :: getOrgCode)
                .collect(Collectors.toList());
        if(CollectionUtils.isEmpty(terminalOrgVos)){
            return CollectionUtils.isEmpty(terminalCodes)?new ArrayList<>():new ArrayList<>(terminalCodes);
        }
//        List<String> terminalCodesFromOrg = mdmCustomerMsgService.findByOrgCodeList(terminalOrgVos);
        List<MdmTerminalROrgEntity> terminalROrgEntities =
                mdmTerminalROrgService.lambdaQuery().in(MdmTerminalROrgEntity::getOrgCode, terminalOrgVos)
                        .select(MdmTerminalROrgEntity::getTerminalCode).list();

        if(!CollectionUtil.listEmpty(terminalROrgEntities)){
            Set<String> collect = terminalROrgEntities.stream().filter(a -> org.apache.commons.lang3.StringUtils.isNotBlank(a.getTerminalCode()))
                    .map(MdmTerminalROrgEntity::getTerminalCode).collect(Collectors.toSet());
            if(collect != null && !collect.isEmpty()) {
                terminalCodes.addAll(collect);
            }
        }
        return CollectionUtils.isEmpty(terminalCodes)?new ArrayList<>():new ArrayList<>(terminalCodes);
    }

    /**
     * 根据编码批量查询是否存在
     * @param codes
     * @return
     */
    @Override
    public Map<String, Boolean> findExistByCodes(List<String> codes) {
        if(CollectionUtil.listEmpty(codes)) {
            return Maps.newHashMap();
        }
        List<AvailableListRuleEntity> entities = this.list(Wrappers.<AvailableListRuleEntity>query().in("code", codes));
        if(entities == null) {
            entities = Lists.newArrayList();
        }
        Map<String, Boolean> result = Maps.newTreeMap();
        entities.forEach(entity -> result.put(entity.getCode(), true));
        codes.forEach(code -> {
            if(result.get(code) == null) {
                result.put(code, false);
            }
        });
        return result;
    }

    /**
     * 删除规则的变动通知
     * @param areaVos
     * @param rules
     */
    private void delAdvise(List<AvailableListRuleAreaVo> areaVos,List<AvailableListRuleEntity> rules){
        if(CollectionUtils.isEmpty(areaVos)){
            return;
        }
        Map<String,Integer> ruleMap = rules.stream()
                .collect(Collectors.toMap(AvailableListRuleEntity::getRuleCode,AvailableListRuleEntity::getDimension));
        Map<String, List<AvailableListRuleAreaVo>> areaMap = areaVos.stream()
                .collect(Collectors.groupingBy(AvailableListRuleAreaVo::getRuleCode));
        Map<Integer,List<String>> typeMap = new HashMap<>(AvailableListRuleEunm.Dimension.values().length);

        for(Map.Entry<String, List<AvailableListRuleAreaVo>> entry : areaMap.entrySet()){
            Integer dimension = ruleMap.get(entry.getKey());
            List<String> codes = typeMap.getOrDefault(dimension, Lists.newArrayList());
            if(dimension.intValue() == AvailableListRuleEunm.Dimension.CUS.getCode().intValue()){
                codes.addAll(entry.getValue().stream().map(AvailableListRuleAreaVo :: getCusCode).collect(Collectors.toList()));
            }else if(dimension.intValue() == AvailableListRuleEunm.Dimension.CUSORG.getCode().intValue()){
                codes.addAll(entry.getValue().stream().map(AvailableListRuleAreaVo :: getOrgCode).collect(Collectors.toList()));
            }else if(dimension.intValue() == AvailableListRuleEunm.Dimension.TERMINAL.getCode().intValue()){
                codes.addAll(entry.getValue().stream().map(AvailableListRuleAreaVo :: getTerminalCode).collect(Collectors.toList()));
            } else if(dimension.intValue() == AvailableListRuleEunm.Dimension.TERMINALORG.getCode().intValue()){
                codes.addAll(entry.getValue().stream().map(AvailableListRuleAreaVo :: getOrgCode).collect(Collectors.toList()));
            }
            typeMap.put(dimension,codes);
        }
        for(Map.Entry<Integer,List<String>> entry : typeMap.entrySet()){
            this.advise(entry.getValue(), AvailableListRuleEunm.Dimension.getByCode(entry.getKey()));
        }
    }


    /**
     * 通知
     * @param codes
     * @param dimension
     */
    private void advise(List<String> codes, AvailableListRuleEunm.Dimension dimension){
        if(dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.CUS.getCode().intValue()){
            advise.adviseTarget(customerChangeAdviseTargetStrategy,codes);
        }else if(dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.CUSORG.getCode().intValue()){
            advise.adviseTarget(customerOrgChangeAdviseTargetStrategy,codes);
        }else if(dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.TERMINAL.getCode().intValue()){
            advise.adviseTarget(terminalChangeAdviseTargetStrategy,codes);
        } else if(dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.TERMINALORG.getCode().intValue()){
            advise.adviseTarget(terminalOrgChangeAdviseTargetStrategy,codes);
        }
    }

    /**
     * 1、入参校验
     * 2、查询实体类
     * 3、通过实体类查询goods和area
     * 4、组装vos
     * @param ids ids
     * @return 查询结果
     */
    private List<AvailableListRuleVo> findByIds(List<String> ids) {
        List<AvailableListRuleVo> ruleVos;
        //1
        com.biz.crm.util.ValidateUtils.validate(ids,"请指定需要查询的规则！");
        //2
        List<AvailableListRuleEntity> entities = this.lambdaQuery()
                .in(AvailableListRuleEntity::getId, ids)
                .list();
        if(null == entities){
            return Lists.newArrayList();
        }
        ruleVos = CrmBeanUtil.copyList(entities,AvailableListRuleVo.class);
        List<String> ruleCodes = entities.stream()
                .map(entity -> entity.getRuleCode())
                .collect(Collectors.toList());
        //3
        List<AvailableListRuleGoodsVo> goodsVos = availableListRuleGoodsService.findByRuleCodes(ruleCodes);

        List<AvailableListRuleAreaVo> areaVos = availableListRuleAreaService.findByRuleCodes(ruleCodes);

        //4
        ruleVos.forEach(ruleVo -> {
            if (null != goodsVos) {
                ruleVo.setGoods(goodsVos.stream()
                        .filter(goodsVo -> ruleVo.getRuleCode().equals(goodsVo.getRuleCode()))
                        .collect(Collectors.toList()));
            }
            if (null != areaVos) {
                ruleVo.setAreaes(areaVos.stream()
                        .filter(areaVo -> ruleVo.getRuleCode().equals(areaVo.getRuleCode()))
                        .collect(Collectors.toList()));
            }
        });
        return ruleVos;
    }
}
