package com.biz.crm.availablelistrule.utils;

import com.biz.crm.availablelistrule.entity.AvailableListRuleEntity;
import com.biz.crm.availablelistrule.entity.AvailableListRuleGoodsEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.utils.ValidateUtils;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleGoodsVo;
import com.biz.crm.util.StringUtils;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 17:49
 **/
public class AvailableListRuleGoodsUtil {


    /**
     * 组装实体类
     * @param vos
     * @param ruleEntity
     * @return
     */
    public static List<AvailableListRuleGoodsEntity> packageEntities(List<AvailableListRuleGoodsVo> vos, AvailableListRuleEntity ruleEntity){
        List<AvailableListRuleGoodsEntity> entities = new ArrayList<>(vos.size());
        for(AvailableListRuleGoodsVo vo : vos){
            if(vo.getProductLevelFlag() == null){
                vo.setProductLevelFlag(YesNoEnum.yesNoEnum.NO.getValue());
            }
            if(vo.getProductLevelFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
                ValidateUtils.validate(StringUtils.isEmpty(vo.getGoodsCode()),"商品编码不能为空!");
                ValidateUtils.validate(StringUtils.isEmpty(vo.getGoodsName()),"商品不能为空!");
            }else {
                ValidateUtils.validate(StringUtils.isEmpty(vo.getProductLevelCode()),"商品系列编码不能为空!");
                ValidateUtils.validate(StringUtils.isEmpty(vo.getProductLevelName()),"商品系列不能为空!");
            }
            AvailableListRuleGoodsEntity entity = new AvailableListRuleGoodsEntity();
            BeanUtils.copyProperties(vo,entity);
            entity.setRuleCode(ruleEntity.getRuleCode());
            entities.add(entity);
        }
        return entities;
    }
}
