package com.biz.crm.bpmrole.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleRelationPositionPageReqVo;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleRelationPositionReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRelationPositionPageRespVo;
import com.biz.crm.position.service.MdmPositionBpmRoleService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 流程角色表
 *
 * @author Tao.Chen
 * @date 2020-11-26 20:07:10
 */
@Slf4j
@RestController
@RequestMapping("/mdmBpmRoleRelationPositionController")
@Api(tags = "MDM-流程角色-关联职位")
@CrmGlobalLog
public class MdmBpmRoleRelationPositionController {

    @Autowired
    private MdmPositionBpmRoleService mdmPositionBpmRoleService;

    @ApiOperation("查询未关联任何流程角色的职位")
    @PostMapping("/findPositionNotRelateAnyBpmRoleList")
    @CrmDictMethod
    public Result<PageResult<MdmBpmRoleRelationPositionPageRespVo>> findPositionNotRelateAnyBpmRoleList(@RequestBody MdmBpmRoleRelationPositionPageReqVo reqVo) {
        PageResult<MdmBpmRoleRelationPositionPageRespVo> page = mdmPositionBpmRoleService.findPositionNotRelateAnyBpmRoleList(reqVo);
        return Result.ok(page);
    }

    @ApiOperation("查询未关联当前流程角色的职位（bpmRoleCode必传）")
    @PostMapping("/findPositionNotRelateCurBpmRoleList")
    @CrmDictMethod
    public Result<PageResult<MdmBpmRoleRelationPositionPageRespVo>> findPositionNotRelateCurBpmRoleList(@RequestBody MdmBpmRoleRelationPositionPageReqVo reqVo) {
        PageResult<MdmBpmRoleRelationPositionPageRespVo> page = mdmPositionBpmRoleService.findPositionNotRelateCurBpmRoleList(reqVo);
        return Result.ok(page);
    }

    @ApiOperation("查询已关联当前流程角色的职位（bpmRoleCode必传）")
    @PostMapping("/findPositionHasRelateCurBpmRoleList")
    @CrmDictMethod
    public Result<PageResult<MdmBpmRoleRelationPositionPageRespVo>> findPositionHasRelateCurBpmRoleList(@RequestBody MdmBpmRoleRelationPositionPageReqVo reqVo) {
        PageResult<MdmBpmRoleRelationPositionPageRespVo> page = mdmPositionBpmRoleService.findPositionHasRelateCurBpmRoleList(reqVo);
        return Result.ok(page);
    }

    @ApiOperation("职位关联流程角色（positionCodeList、bpmRoleCode）")
    @PostMapping("/positionRelationBpmRole")
    public Result positionRelationBpmRole(@RequestBody MdmBpmRoleRelationPositionReqVo reqVo) {
        mdmPositionBpmRoleService.positionRelationBpmRole(reqVo);
        return Result.ok();
    }

    @ApiOperation("替换职位关联的流程角色（ids、bpmRoleCode）")
    @PostMapping("/replaceBindBpmRole")
    public Result replaceBindBpmRole(@RequestBody MdmBpmRoleRelationPositionReqVo reqVo) {
        mdmPositionBpmRoleService.replaceBindBpmRole(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "解除职位与流程角色关联关系", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "关联表id集合", required = true, paramType = "body")
    })
    @PostMapping("/unbindByRelationIds")
    public Result unbindByRelationIds(@RequestBody List<String> ids) {
        mdmPositionBpmRoleService.removeByIds(ids);
        return Result.ok();
    }
}
