package com.biz.crm.bpmrole.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.bpmrole.model.MdmBpmRoleEntity;
import com.biz.crm.bpmrole.provider.MdmBpmRoleProvider;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleReqVo;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleSelectReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleSelectRespVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 流程角色表
 *
 * @author Tao.Chen
 * @date 2020-11-26 20:07:10
 */
public interface MdmBpmRoleMapper extends BaseMapper<MdmBpmRoleEntity> {

    /**
     * 列表
     *
     * @param page
     * @param mdmBpmRoleReqVo
     * @return
     */
    @SqlPrivilege(
        extPosSql = "select 1 from mdm_position_bpm_role where bpm_role_code=a.bpm_role_code and position_code in",
        extOrgSql = "select 1 from mdm_position_bpm_role pbr left join mdm_position p on p.position_code=pbr.position_code where pbr.bpm_role_code=a.bpm_role_code and p.org_code in"
    )
    List<MdmBpmRoleRespVo> findList(Page<MdmBpmRoleRespVo> page,
                                    @Param("vo") MdmBpmRoleReqVo mdmBpmRoleReqVo);

    /**
     * 列表(provider)
     *
     * @param page
     * @param mdmBpmRoleReqVo
     * @return
     */
    @SelectProvider(type = MdmBpmRoleProvider.class,method = "findList")
    List<MdmBpmRoleRespVo> findListBpm(Page<MdmBpmRoleRespVo> page, @Param("vo") MdmBpmRoleReqVo mdmBpmRoleReqVo);


    /**
     * 查询流程角色下拉框选择数据
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(extPosSql = "select 1 from mdm_position_bpm_role where bpm_role_code=a.bpm_role_code and position_code in")
    List<MdmBpmRoleSelectRespVo> bpmRoleSelectList(Page<MdmBpmRoleSelectRespVo> page, @Param("vo") MdmBpmRoleSelectReqVo reqVo);
}
