package com.biz.crm.button.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.button.service.MdmButtonService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.button.MdmButtonReqVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import rx.internal.operators.BackpressureUtils;

import java.util.List;

/**
 * 按钮表
 *
 * @author zxw
 * @date 2020-11-18 11:33:08
 */
@Slf4j
@RestController
@RequestMapping("/mdmbutton")
@Api(tags = "按钮")
@CrmGlobalLog
public class MdmButtonController {

    @Autowired
    private MdmButtonService mdmButtonService;

    @ApiOperation(value = "查询分页列表")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<PageResult<MdmButtonRespVo>> list(@RequestBody MdmButtonReqVo mdmButtonReqVo) {
        PageResult<MdmButtonRespVo> result = mdmButtonService.findList(mdmButtonReqVo);
        return Result.ok(result);
    }

    @ApiOperation("条件列表查询")
    @PostMapping("/listCondition")
    @CrmDictMethod
    public Result<List<MdmButtonRespVo>> listCondition(@RequestBody MdmButtonReqVo mdmButtonReqVo) {
        List<MdmButtonRespVo> result = mdmButtonService.listCondition(mdmButtonReqVo);
        return Result.ok(result);
    }


    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "buttonCode", value = "区域编码", required = false, dataType = "String", paramType = "query")
    })
    @CrmDictMethod
    public Result<MdmButtonRespVo> query(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "buttonCode", required = false) String buttonCode) {
        MdmButtonRespVo respVo = mdmButtonService.query(id,buttonCode);
        return Result.ok(respVo);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result<Object> save(@RequestBody MdmButtonReqVo mdmButtonReqVo) {
        mdmButtonService.save(mdmButtonReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody MdmButtonReqVo mdmButtonReqVo) {
        mdmButtonService.update(mdmButtonReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    public Result<Object> delete(@RequestBody List<String> ids) {
        mdmButtonService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    public Result<Object> enable(@RequestBody List<String> ids) {
        mdmButtonService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    public Result<Object> disable(@RequestBody List<String> ids) {
        mdmButtonService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
