package com.biz.crm.button.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.button.model.MdmButtonRoleEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.buttonrole.MdmButtonRoleReqVo;
import com.biz.crm.nebular.mdm.buttonrole.MdmButtonRoleRespVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonVo;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 按钮-角色关联接口
 *
 * @author zxw
 * @date 2020-11-18 11:51:48
 */
public interface MdmButtonRoleService extends IService<MdmButtonRoleEntity> {

    /**
     * 列表
     *
     * @param mdmButtonRoleReqVo
     * @return PageResult<MdmButtonRoleRespVo>
     */
    PageResult<MdmButtonRoleRespVo> findList(MdmButtonRoleReqVo mdmButtonRoleReqVo);

    /**
     * 查询
     *
     * @param mdmButtonRoleReqVo
     * @return MdmButtonRoleRespVo
     */
    MdmButtonRoleRespVo query(MdmButtonRoleReqVo mdmButtonRoleReqVo);

    /**
     * 新增
     *
     * @param mdmButtonRoleReqVo
     * @return
     */
    void save(MdmButtonRoleReqVo mdmButtonRoleReqVo);

    /**
     * 更新
     *
     * @param mdmButtonRoleReqVo
     * @return
     */
    void update(MdmButtonRoleReqVo mdmButtonRoleReqVo);

    /**
     * 删除
     *
     * @param mdmButtonRoleReqVo
     * @return
     */
    void deleteBatch(MdmButtonRoleReqVo mdmButtonRoleReqVo);

    List<String> findButtonCodeByRole(List<String> roleCodeList, String parentCode, String functionCode);

    /**
     * 查询角色编码关联的按钮编码
     * @param roleCode 角色编码
     * @return list
     */
    List<String> findButtonCodeByRole(String roleCode,String parentCode,String functionCode);

    /**
     * 维护角色与按钮关系
     * @param roleCode 角色编码
     * @param mdmRoleSubButtonVos vo
     */
    void setUp(String roleCode, List<MdmRoleSubButtonVo> mdmRoleSubButtonVos);

    void deleteByRoleCodeList(List<String> roleCodeList);
}

