package com.biz.crm.coderule.controller;

import com.biz.crm.coderule.service.MdmCodeRuleGeneratorService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 编码生成
 *
 * @author Tao.Chen
 * @date 2020-11-05 10:47:13
 */
@Slf4j
@RestController
@RequestMapping("/mdmcoderulegenerator")
@Api(tags = "编码生成")
public class MdmCodeRuleGeneratorController {

    @Autowired
    private MdmCodeRuleGeneratorService mdmCodeRuleGeneratorService;

    @ApiOperation(value = "生成多个编码")
    @PostMapping("/generateCodeList")
    public Result<List<String>> generateCodeList(@RequestParam("ruleCode") String ruleCode, @RequestParam("number") Integer number) {
        return Result.ok(mdmCodeRuleGeneratorService.generateCodeList(ruleCode, number));
    }

}
