package com.biz.crm.common;

import lombok.Data;

/**
 * 通用构造器
 *
 * @author zxw
 * @date 2020-09-03 21:43
 **/
@Data
public abstract class BaseBuilder<T> {

    protected T t;

    /**
     * 初始化处理
     *
     * @return builder
     */
    public BaseBuilder<T> init(T t) {
        this.t = t;
        return this;
    }

    /**
     * 缓存处理
     *
     * @return builder
     */
    public BaseBuilder<T> cache() {
        return this;
    }

    /**
     * 事件处理
     *
     * @return builder
     */
    public BaseBuilder<T> publish() {
        return this;
    }

    /**
     * 日志处理
     *
     * @return builder
     */
    public BaseBuilder<T> log() {
        return this;
    }

    /**
     * 持久化
     *
     * @return builder
     */
    public BaseBuilder<T> persistence() {
        return this;
    }


    /**
     * 校验处理
     *
     * @return builder
     */
    public BaseBuilder<T> valid() {
        return this;
    }

    /**
     * 转换处理
     *
     * @return builder
     */
    public BaseBuilder<T> convert() {
        return this;
    }

    /**
     * 后置处理
     * @return builder
     */
    public BaseBuilder<T> after() {
        return this;
    }
}
