package com.biz.crm.common.controller;

import com.biz.crm.common.service.BaseLazyTreeService;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeReqVo;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 懒加载树
 *
 * @author Tao.Chen
 * @date 2020-12-14 17:12:13
 */
@RestController
@RequestMapping("/baseLazyTreeController")
@Api(tags = "公共树（懒加载）")
public class BaseLazyTreeController {

    @Resource
    private BaseLazyTreeService baseLazyTreeService;

    @ApiOperation(value = "组织懒加载树", notes = "什么都不传返回第一层，传parentCode返回这个编码的下一级，传name模糊查询并且查询出所有上级再构建成树形，优先级parentCode > name")
    @PostMapping("/orgLazyTree")
    public Result<List<BaseLazyTreeRespVo>> orgLazyTree(@RequestBody BaseLazyTreeReqVo reqVo) {
        return Result.ok(baseLazyTreeService.orgLazyTree(reqVo));
    }

    @ApiOperation(value = "菜单懒加载树", notes = "什么都不传返回第一层，传parentCode返回这个编码的下一级，传name模糊查询并且查询出所有上级再构建成树形，优先级parentCode > name")
    @PostMapping("/menuLazyTree")
    public Result<List<BaseLazyTreeRespVo>> menuLazyTree(@RequestBody BaseLazyTreeReqVo reqVo) {
        return Result.ok(baseLazyTreeService.menuLazyTree(reqVo));
    }

    @ApiOperation(value = "产品层级懒加载树", notes = "什么都不传返回第一层，传parentCode返回这个编码的下一级，传name模糊查询并且查询出所有上级再构建成树形，优先级parentCode > name")
    @PostMapping("/productLevelLazyTree")
    public Result<List<BaseLazyTreeRespVo>> productLevelLazyTree(@RequestBody BaseLazyTreeReqVo reqVo) {
        return Result.ok(baseLazyTreeService.productLevelLazyTree(reqVo));
    }

    @ApiOperation(value = "客户组织懒加载树", notes = "什么都不传返回第一层，传parentCode返回这个编码的下一级，传name模糊查询并且查询出所有上级再构建成树形，优先级parentCode > name")
    @PostMapping("/customerOrgLazyTree")
    public Result<List<BaseLazyTreeRespVo>> customerOrgLazyTree(@RequestBody BaseLazyTreeReqVo reqVo) {
        return Result.ok(baseLazyTreeService.customerOrgLazyTree(reqVo));
    }

}
