package com.biz.crm.common.controller;

import com.biz.crm.common.service.BaseTreeService;
import com.biz.crm.nebular.mdm.common.BaseTreeReqVo;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.org.req.BaseOrgTreeReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 匹配前端：公共树组织控制器
 *
 * @author zxw
 * @date 2020-10-29 13:35
 **/
@RestController
@RequestMapping("/baseTreeController")
@Api(tags = "公共树")
public class BaseTreeController {

    @Resource
    private BaseTreeService baseTreeService;

    @ApiOperation("组织树")
    @PostMapping("/orgTree")
    public Result<List<BaseTreeRespVo>> orgTree(@RequestBody BaseOrgTreeReqVo reqVo) {
        return Result.ok(baseTreeService.orgTree(reqVo));
    }

    @ApiOperation("菜单树")
    @PostMapping("/menuTree")
    public Result<List<BaseTreeRespVo>> menuTree(@RequestBody BaseTreeReqVo reqVo) {
        return Result.ok(baseTreeService.menuTree(reqVo));
    }

    @ApiOperation("产品层级树")
    @PostMapping("/productLevelTree")
    public Result<List<BaseTreeRespVo>> productLevelTree(@RequestBody BaseTreeReqVo reqVo) {
        return Result.ok(baseTreeService.productLevelTree(reqVo));
    }

    @ApiOperation("客户组织树")
    @PostMapping("/customerOrgTree")
    public Result<List<BaseTreeRespVo>> customerOrgTree(@RequestBody BaseTreeReqVo reqVo) {
        return Result.ok(baseTreeService.customerOrgTree(reqVo));
    }
}
