package com.biz.crm.common.service;

import com.biz.crm.nebular.mdm.common.BaseLazyTreeReqVo;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeRespVo;

import java.util.List;

public interface BaseLazyTreeService {

    /**
     * 组织懒加载树
     *
     * @param reqVo
     * @return
     */
    List<BaseLazyTreeRespVo> orgLazyTree(BaseLazyTreeReqVo reqVo);

    /**
     * 菜单懒加载树
     *
     * @param reqVo
     * @return
     */
    List<BaseLazyTreeRespVo> menuLazyTree(BaseLazyTreeReqVo reqVo);

    /**
     * 产品层级懒加载树
     *
     * @param reqVo
     * @return
     */
    List<BaseLazyTreeRespVo> productLevelLazyTree(BaseLazyTreeReqVo reqVo);

    /**
     * 客户组织懒加载树
     *
     * @param reqVo
     * @return
     */
    List<BaseLazyTreeRespVo> customerOrgLazyTree(BaseLazyTreeReqVo reqVo);

}
