package com.biz.crm.common.service.impl;

import com.biz.crm.common.service.BaseTreeService;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.cusorg.service.MdmCusOrgService;
import com.biz.crm.eunm.mdm.MdmPermissionObjEnum;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.common.BaseTreeReqVo;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.org.req.BaseOrgTreeReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentUserPermissionRespVo;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PermissionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 通用树业务层
 *
 * @author zxw
 * @date 2020-10-29 13:49
 **/
@Slf4j
@Service
@ConditionalOnMissingBean(name = "BaseTreeServiceExpandImpl")
public class BaseTreeServiceImpl implements BaseTreeService {

    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmProductLevelService mdmProductLevelService;
    @Resource
    private MdmCusOrgService mdmCusOrgService;
    @Resource
    private MdmFunctionService mdmFunctionService;

    @Override
    public List<BaseTreeRespVo> orgTree(BaseOrgTreeReqVo reqVo) {
        List<BaseTreeRespVo> tree = new ArrayList<>();

        //权限过滤
        List<String> orgPermissionList = new ArrayList<>();
        MdmCurrentPermissionRespVo mdmCurrentPermissionRespVo = PermissionUtil.currentUserPermissionList();
        if (mdmCurrentPermissionRespVo != null) {
            List<String> excludePermissionObjCodeList = mdmCurrentPermissionRespVo.getExcludePermissionObjCodeList();
            if (excludePermissionObjCodeList == null || !excludePermissionObjCodeList.contains(MdmPermissionObjEnum.ORG.getCode())) {
                //没有排除说明是全部组织
                List<String> permissionObjCodeList = mdmCurrentPermissionRespVo.getPermissionObjCodeList();
                if (!CollectionUtils.isEmpty(permissionObjCodeList) && permissionObjCodeList.contains(MdmPermissionObjEnum.ORG.getCode())) {
                    List<MdmCurrentUserPermissionRespVo> userPermissionList = mdmCurrentPermissionRespVo.getUserPermissionList();
                    if (!CollectionUtils.isEmpty(userPermissionList)) {
                        //获取当前用户能访问的组织
                        List<String> orgCodeList = userPermissionList.stream()
                                .filter(x -> MdmPermissionObjEnum.ORG.getCode().equals(x.getPermissionObjCode()))
                                .filter(x -> !CollectionUtils.isEmpty(x.getPermissionValueList()))
                                .flatMap(x -> x.getPermissionValueList().stream())
                                .collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(orgCodeList)) {
                            return new ArrayList<>();
                        }
                        orgPermissionList = orgCodeList;
                    }
                }
            }
        }

        Set<String> excludeSet = new HashSet<>(16);
        if (StringUtils.isNotEmpty(reqVo.getExcludeCodeAndChildren())) {
            excludeSet.add(reqVo.getExcludeCodeAndChildren());
        }
        String includeTopRuleCode = null;
        if (StringUtils.isNotEmpty(reqVo.getIncludeCodeAndChildren())) {
            MdmOrgRespVo mdmOrgRespVo = mdmOrgService.queryByOrgCode(reqVo.getIncludeCodeAndChildren());
            if (mdmOrgRespVo != null) {
                includeTopRuleCode = mdmOrgRespVo.getRuleCode();
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getExcludePositionChildrenOrgCodeList())) {
            List<String> orgCodeList = mdmOrgService.findAllChildrenOrgCodeListOfPositionChildrenList(reqVo.getExcludePositionChildrenOrgCodeList());
            if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList)) {
                excludeSet.addAll(orgCodeList);
            }
        }

        List<MdmOrgEntity> list = mdmOrgService.lambdaQuery()
                .eq(StringUtils.isNotEmpty(reqVo.getEnableStatus()), MdmOrgEntity::getEnableStatus, reqVo.getEnableStatus())
                .in(!CollectionUtils.isEmpty(orgPermissionList), MdmOrgEntity::getOrgCode, orgPermissionList)
                .like(!StringUtils.isEmpty(reqVo.getName()), MdmOrgEntity::getOrgName, reqVo.getName())
                .likeRight(!StringUtils.isEmpty(includeTopRuleCode), MdmOrgEntity::getRuleCode, includeTopRuleCode)
                .select(MdmOrgEntity::getId, MdmOrgEntity::getParentCode, MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName, MdmOrgEntity::getRuleCode)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            if (StringUtils.isNotEmpty(reqVo.getName())) {
                Set<String> set = TreeRuleCodeUtil.splitParentRuleCodes(list.stream().map(MdmOrgEntity::getRuleCode).collect(Collectors.toList()));
                if (!set.isEmpty()) {
                    list = mdmOrgService.lambdaQuery()
                            .in(MdmOrgEntity::getRuleCode, set)
                            .in(!CollectionUtils.isEmpty(orgPermissionList), MdmOrgEntity::getOrgCode, orgPermissionList)
                            .likeRight(!StringUtils.isEmpty(includeTopRuleCode), MdmOrgEntity::getRuleCode, includeTopRuleCode)
                            .select(MdmOrgEntity::getId, MdmOrgEntity::getParentCode, MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName, MdmOrgEntity::getRuleCode)
                            .list();
                }
            }
            List<BaseTreeRespVo> collect = list.stream().map(x -> {
                BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
                baseTreeRespVo.setId(x.getId());
                baseTreeRespVo.setParentCode(x.getParentCode());
                baseTreeRespVo.setCode(x.getOrgCode());
                baseTreeRespVo.setName(x.getOrgName());
                return baseTreeRespVo;
            }).collect(Collectors.toList());


            tree = generateTreeByParentCode(collect);
            if (!excludeSet.isEmpty()) {
                excludeCodeAndChildrenBatch(tree, excludeSet);
            }
        }
        return tree;
    }

    @Override
    public List<BaseTreeRespVo> menuTree(BaseTreeReqVo baseTreeReqVo) {
        List<BaseTreeRespVo> tree = new ArrayList<>();
        List<MdmFunctionEntity> list = mdmFunctionService.lambdaQuery()
                .eq(StringUtils.isNotEmpty(baseTreeReqVo.getEnableStatus()), MdmFunctionEntity::getEnableStatus, baseTreeReqVo.getEnableStatus())
                .like(StringUtils.isNotEmpty(baseTreeReqVo.getName()), MdmFunctionEntity::getFunctionName, baseTreeReqVo.getName())
                .select(MdmFunctionEntity::getId, MdmFunctionEntity::getFunctionCode, MdmFunctionEntity::getFunctionName, MdmFunctionEntity::getParentCode)
                .list();

        if (StringUtils.isNotEmpty(baseTreeReqVo.getName()) && CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Set<String> set = new HashSet<>();
            for (MdmFunctionEntity item :
                    list) {
                set.add(item.getFunctionCode());
                String parentCode = item.getParentCode();
                while (StringUtils.isNotEmpty(parentCode)) {
                    MdmFunctionEntity one = mdmFunctionService.lambdaQuery()
                            .eq(MdmFunctionEntity::getFunctionCode, parentCode)
                            .select(MdmFunctionEntity::getFunctionCode, MdmFunctionEntity::getParentCode)
                            .one();
                    if (one == null || set.contains(one.getFunctionCode())) {
                        break;
                    }
                    set.add(one.getFunctionCode());
                    parentCode = one.getParentCode();
                }
            }
            if (!set.isEmpty()) {
                List<List<String>> partition = Lists.partition(new ArrayList<>(set), 500);
                list = new ArrayList<>();
                for (List<String> part :
                        partition) {
                    list.addAll(mdmFunctionService.lambdaQuery()
                            .in(MdmFunctionEntity::getFunctionCode, part)
                            .select(MdmFunctionEntity::getId, MdmFunctionEntity::getFunctionCode, MdmFunctionEntity::getFunctionName, MdmFunctionEntity::getParentCode)
                            .list());
                }
            }
        }

        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<BaseTreeRespVo> collect = list.stream().map(x -> {
                BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
                baseTreeRespVo.setId(x.getId());
                baseTreeRespVo.setParentCode(x.getParentCode());
                baseTreeRespVo.setCode(x.getFunctionCode());
                baseTreeRespVo.setName(x.getFunctionName());
                return baseTreeRespVo;
            }).collect(Collectors.toList());
            tree = generateTreeByParentCode(collect);

        }

        return tree;
    }

    @Override
    public List<BaseTreeRespVo> productLevelTree(BaseTreeReqVo baseTreeReqVo) {
        List<BaseTreeRespVo> tree = new ArrayList<>();
        List<MdmProductLevelEntity> list = mdmProductLevelService.lambdaQuery()
                .eq(StringUtils.isNotEmpty(baseTreeReqVo.getEnableStatus()), MdmProductLevelEntity::getEnableStatus, baseTreeReqVo.getEnableStatus())
                .like(StringUtils.isNotEmpty(baseTreeReqVo.getName()), MdmProductLevelEntity::getProductLevelName, baseTreeReqVo.getName())
                .select(MdmProductLevelEntity::getId, MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName, MdmProductLevelEntity::getParentCode, MdmProductLevelEntity::getRuleCode)
                .list();

        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            if (StringUtils.isNotEmpty(baseTreeReqVo.getName())) {
                //查询所有符合的
                Set<String> set = TreeRuleCodeUtil.splitParentRuleCodes(list.stream().map(MdmProductLevelEntity::getRuleCode).collect(Collectors.toList()));
                if (!set.isEmpty()) {
                    List<List<String>> partition = Lists.partition(new ArrayList<>(set), 500);
                    list = new ArrayList<>();
                    for (List<String> part :
                            partition) {
                        list.addAll(mdmProductLevelService.lambdaQuery()
                                .in(MdmProductLevelEntity::getRuleCode, part)
                                .select(MdmProductLevelEntity::getId, MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName, MdmProductLevelEntity::getParentCode, MdmProductLevelEntity::getRuleCode)
                                .list());
                    }
                }
            }
            List<BaseTreeRespVo> collect = list.stream().map(x -> {
                BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
                baseTreeRespVo.setId(x.getId());
                baseTreeRespVo.setParentCode(x.getParentCode());
                baseTreeRespVo.setCode(x.getProductLevelCode());
                baseTreeRespVo.setName(x.getProductLevelName());
                return baseTreeRespVo;
            }).collect(Collectors.toList());
            tree = generateTreeByParentCode(collect);
            if (StringUtils.isNotEmpty(baseTreeReqVo.getExcludeCodeAndChildren())) {
                excludeCodeAndChildren(tree, baseTreeReqVo.getExcludeCodeAndChildren());
            }
        }
        return tree;
    }

    @Override
    public List<BaseTreeRespVo> customerOrgTree(BaseTreeReqVo baseTreeReqVo) {
        List<BaseTreeRespVo> tree = new ArrayList<>();
        List<MdmCusOrgEntity> list = mdmCusOrgService.lambdaQuery()
                .eq(StringUtils.isNotEmpty(baseTreeReqVo.getEnableStatus()), MdmCusOrgEntity::getEnableStatus, baseTreeReqVo.getEnableStatus())
                .like(StringUtils.isNotEmpty(baseTreeReqVo.getName()), MdmCusOrgEntity::getCustomerOrgName, baseTreeReqVo.getName())
                .select(MdmCusOrgEntity::getId, MdmCusOrgEntity::getCustomerOrgCode, MdmCusOrgEntity::getCustomerOrgName, MdmCusOrgEntity::getParentCode, MdmCusOrgEntity::getRuleCode)
                .list();

        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            if (StringUtils.isNotEmpty(baseTreeReqVo.getName())) {
                //查询所有符合的
                Set<String> set = TreeRuleCodeUtil.splitParentRuleCodes(list.stream().map(MdmCusOrgEntity::getRuleCode).collect(Collectors.toList()));
                if (!set.isEmpty()) {
                    List<List<String>> partition = Lists.partition(new ArrayList<>(set), 500);
                    list = new ArrayList<>();
                    for (List<String> part :
                            partition) {
                        list.addAll(mdmCusOrgService.lambdaQuery()
                                .in(MdmCusOrgEntity::getRuleCode, part)
                                .select(MdmCusOrgEntity::getId, MdmCusOrgEntity::getCustomerOrgCode, MdmCusOrgEntity::getCustomerOrgName, MdmCusOrgEntity::getParentCode, MdmCusOrgEntity::getRuleCode)
                                .list());
                    }
                }
            }
            List<BaseTreeRespVo> collect = list.stream().map(x -> {
                BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
                baseTreeRespVo.setId(x.getId());
                baseTreeRespVo.setParentCode(x.getParentCode());
                baseTreeRespVo.setCode(x.getCustomerOrgCode());
                baseTreeRespVo.setName(x.getCustomerOrgName());
                return baseTreeRespVo;
            }).collect(Collectors.toList());
            tree = generateTreeByParentCode(collect);
            if (StringUtils.isNotEmpty(baseTreeReqVo.getExcludeCodeAndChildren())) {
                excludeCodeAndChildren(tree, baseTreeReqVo.getExcludeCodeAndChildren());
            }
        }
        return tree;
    }

    /**
     * 构建树形结构
     *
     * @param totalList
     * @return
     */
    protected List<BaseTreeRespVo> generateTreeByParentCode(List<BaseTreeRespVo> totalList) {

        //构建树list
        List<BaseTreeRespVo> treeList = new ArrayList<>();
        //当前操作层级数据
        List<BaseTreeRespVo> curLevelList = new ArrayList<>();
        //未操作数据
        List<BaseTreeRespVo> restList = new ArrayList<>();

        //key:id
        Map<String, BaseTreeRespVo> totalMap = totalList.stream().collect(Collectors.toMap(BaseTreeRespVo::getCode, v -> v));

        //查找第一层
        for (BaseTreeRespVo item :
                totalList) {
            if (StringUtils.isEmpty(item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                curLevelList.add(item);
            } else {
                restList.add(item);
            }
        }

        //构建数据，从第二层开始
        while (curLevelList.size() > 0 && restList.size() > 0) {
            List<BaseTreeRespVo> restTempList = new ArrayList<>();
            List<BaseTreeRespVo> curLevelTempList = new ArrayList<>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(BaseTreeRespVo::getCode, BaseTreeRespVo::getCode, (v1, v2) -> v1));
            Map<String, List<BaseTreeRespVo>> curLevelChildrenMap = new HashMap<>();

            for (BaseTreeRespVo item :
                    restList) {
                if (curLevelMap.containsKey(item.getParentCode())) {
                    curLevelTempList.add(item);

                    List<BaseTreeRespVo> childrenList = new ArrayList<>();
                    if (curLevelChildrenMap.containsKey(item.getParentCode())) {
                        childrenList.addAll(curLevelChildrenMap.get(item.getParentCode()));
                    }
                    childrenList.add(item);
                    curLevelChildrenMap.put(item.getParentCode(), childrenList);
                } else {
                    restTempList.add(item);
                }
            }

            for (BaseTreeRespVo item :
                    curLevelList) {
                if (curLevelChildrenMap.containsKey(item.getCode())) {
                    item.setChildren(curLevelChildrenMap.get(item.getCode()));
                }
            }

            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }

        return treeList;
    }

    /**
     * 从树形结构中移除某个节点
     *
     * @param tree                   树
     * @param excludeCodeAncChildren 需要移除的编码
     */
    protected void excludeCodeAndChildren(List<BaseTreeRespVo> tree, String excludeCodeAncChildren) {
        if (CollectionUtil.listNotEmptyNotSizeZero(tree) && StringUtils.isNotEmpty(excludeCodeAncChildren)) {

            Iterator<BaseTreeRespVo> iterator = tree.iterator();
            while (iterator.hasNext()) {
                BaseTreeRespVo item = iterator.next();
                if (item.getCode().equals(excludeCodeAncChildren)) {
                    iterator.remove();
                    return;
                }
                excludeCodeAndChildren(item.getChildren(), excludeCodeAncChildren);
            }
        }
    }

    /**
     * 从树形结构中移除多个节点
     *
     * @param tree
     * @param set
     */
    protected void excludeCodeAndChildrenBatch(List<BaseTreeRespVo> tree, Set<String> set) {
        if (CollectionUtil.listNotEmptyNotSizeZero(tree) && !set.isEmpty()) {
            Iterator<BaseTreeRespVo> iterator = tree.iterator();
            while (iterator.hasNext()) {
                BaseTreeRespVo item = iterator.next();
                if (set.contains(item.getCode())) {
                    iterator.remove();
                    continue;
                }
                excludeCodeAndChildrenBatch(item.getChildren(), set);
            }
        }
    }

}
