package com.biz.crm.config;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * @author zxw
 * @date 2021-02-28 11:01
 **/
@Aspect
@Component
public class CrmDataSourceAspect {

    private static final Logger log = LoggerFactory.getLogger(CrmDataSourceAspect.class);

    @Around(value = "@within(CrmDataSource)||@annotation(CrmDataSource)")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        CrmDataSource clsAnnotation = pjp.getTarget().getClass().getAnnotation(CrmDataSource.class);
        Method method = ((MethodSignature) pjp.getSignature()).getMethod();
        CrmDataSource methodAnnotation = method.getAnnotation(CrmDataSource.class);
        log.info("类注解:{}", clsAnnotation);
        log.info("方法注解:{}", methodAnnotation);
        CrmDataSource annotation = methodAnnotation != null ? methodAnnotation : clsAnnotation;
        if (annotation != null) {
            DynamicDataSourceContextHolder.setDataSourceType(annotation.value().name());
        }
        try {
            return pjp.proceed();
        } finally {
            DynamicDataSourceContextHolder.removeDataSourceType();
        }
    }
}
