package com.biz.crm.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author zxw
 * @date 2021-02-28 10:17
 **/
public class DynamicDataSourceContextHolder {

    public static final Logger log = LoggerFactory.getLogger(DynamicDataSourceContextHolder.class);

    private static final ThreadLocal<String> CONTEXT_HOLDER = new ThreadLocal<>();

    public static void setDataSourceType(String dataSourceType) {
        log.info("设置动态数据源入参:{}",dataSourceType);
        if (!DataSourceType.contain(dataSourceType)) {
            throw new RuntimeException("undefined dataSourceType");
        }
        CONTEXT_HOLDER.set(dataSourceType);
    }

    public static void removeDataSourceType() {
        CONTEXT_HOLDER.remove();
    }

    public static String getDataSourceType() {
        return CONTEXT_HOLDER.get();
    }
}
