package com.biz.crm.cusorg.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.cusorg.service.MdmCusOrgService;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgRedisVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgReloadRedisVo;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 客户组织表redis缓存数据查询请求接口类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@RestController
@RequestMapping("/mdmCustomerOrgRedisController")
@CrmGlobalLog
public class MdmCustomerOrgRedisController {

    @Autowired
    private MdmCusOrgService mdmCusOrgService;

    /**
     * 根据客户组织编码集合获取客户组织详情redis缓存数据
     *
     * @param customerOrgCodeList 客户组织编码集合
     * @return
     */
    @PostMapping("/findRedisListByCustomerOrgCodeList")
    public Result<List<MdmCustomerOrgRedisVo>> findRedisListByCustomerOrgCodeList(@RequestBody List<String> customerOrgCodeList) {
        return Result.ok(mdmCusOrgService.findRedisListByCustomerOrgCodeList(customerOrgCodeList));
    }

    /**
     * 根据客户组织编码集合获取客户组织上级redis缓存数据
     *
     * @param customerOrgCodeList 客户组织编码集合
     * @return
     */
    @PostMapping("/findRedisCustomerOrgParentListByCodeList")
    public Result<List<MdmCustomerOrgParentChildrenRedisVo>> findRedisCustomerOrgParentListByCodeList(@RequestBody List<String> customerOrgCodeList) {
        return Result.ok(mdmCusOrgService.findRedisCustomerOrgParentListByCodeList(customerOrgCodeList));
    }

    /**
     * 根据客户组织编码集合获取客户组织下级redis缓存数据
     *
     * @param customerOrgCodeList 客户组织编码集合
     * @return
     */
    @PostMapping("/findRedisCustomerOrgChildrenListByCodeList")
    public Result<List<MdmCustomerOrgParentChildrenRedisVo>> findRedisCustomerOrgChildrenListByCodeList(@RequestBody List<String> customerOrgCodeList) {
        return Result.ok(mdmCusOrgService.findRedisCustomerOrgChildrenListByCodeList(customerOrgCodeList));
    }

    /**
     * 获取全部客户组织redis缓存数据
     *
     * @return
     */
    @PostMapping("/findRedisReloadList")
    public Result<List<MdmCustomerOrgReloadRedisVo>> findRedisReloadList() {
        return Result.ok(mdmCusOrgService.findRedisReloadList());
    }

}
