package com.biz.crm.cusorg.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2021-01-08 14:22
 **/
public class MdmCusOrgProvider {

    public String listProvider(Map<String,Object> map){
        CusOrgVo vo = (CusOrgVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){{
            SELECT(" a.*,b.customer_org_name AS parent_name");
            FROM("mdm_cus_org a");
            LEFT_OUTER_JOIN("mdm_cus_org b ON a.parent_code = b.customer_org_code");
            if(StringUtils.isNotEmpty(vo.getCustomerOrgCode())){
                WHERE("a.customer_org_code like " + ProviderUtil.bindPercent(vo.getCustomerOrgCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getCustomerOrgName())){
                WHERE("a.customer_org_name like " +ProviderUtil.bindPercent(vo.getCustomerOrgName(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getCustomerOrgLevel())){
                WHERE("a.customer_org_level=#{vo.customerOrgLevel}");
            }
            if(StringUtils.isNotEmpty(vo.getCustomerOrgType())){
               WHERE("a.customer_org_type=#{vo.customerOrgType}");
            }
            if(StringUtils.isNotEmpty(vo.getEnableStatus())){
                WHERE("a.enable_status=#{vo.enableStatus}");
            }
            if(StringUtils.isNotEmpty(vo.getCodeOrgName())){
                String codeOrgName = ProviderUtil.bindPercent(vo.getCodeOrgName(), MdmProviderEnum.SQL_JOIN_ALL);
                WHERE("(a.customer_org_code like "+codeOrgName+" or a.customer_org_name like "+codeOrgName);
            }
            if(StringUtils.isNotEmpty(vo.getRuleCode())){
                WHERE("a.rule_code like "+ProviderUtil.bindPercent(vo.getRuleCode(),MdmProviderEnum.SQL_JOIN_RIGHT));
            }
            if(StringUtils.isNotEmpty(vo.getParentCode())){
                WHERE("a.parent_code=#{vo.parentCode}");
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("a.create_date desc,a.create_date_second desc");
        }}.toString();
    }
}
