package com.biz.crm.customer.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customer.service.MdmCustomerAddressService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressConditionReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 客户信息：收货地址
 *
 * @author zxw
 * @date 2020-09-10 12:09:54
 */
@Slf4j
@RestController
@RequestMapping("/mdmCustomerAddressController")
@Api(tags = "客户信息：收货地址")
@CrmGlobalLog
public class MdmCustomerAddressController {
    @Resource
    private MdmCustomerAddressService mdmCustomerAddressService;

    @ApiOperation(value = "分页查询")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerAddressRespVo>> list(@RequestBody MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        PageResult<MdmCustomerAddressRespVo> result = mdmCustomerAddressService.findList(mdmCustomerAddressReqVo);
        return Result.ok(result);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
    })
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmDictMethod
    public Result<MdmCustomerAddressRespVo> query(@RequestParam("id") String id) {
        MdmCustomerAddressRespVo respVo = mdmCustomerAddressService.query(id);
        return Result.ok(respVo);
    }

    @ApiOperation("条件列表查询")
    @PostMapping("/listCondition")
    public Result<List<MdmCustomerAddressRespVo>> listCondition(@RequestBody MdmCustomerAddressConditionReqVo mdmCustomerAddressConditionReqVo) {
        List<MdmCustomerAddressRespVo> list = mdmCustomerAddressService.listCondition(mdmCustomerAddressConditionReqVo);
        return Result.ok(list);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result<Object> save(@RequestBody MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        mdmCustomerAddressService.save(mdmCustomerAddressReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        mdmCustomerAddressService.update(mdmCustomerAddressReqVo);
        return Result.ok("修改成功");
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    public Result<Object> delete(@RequestBody List<String> ids) {
        mdmCustomerAddressService.deleteBatch(ids);
        return Result.ok("删除成功");
    }


}
