package com.biz.crm.customer.controller;


import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customer.service.MdmCustomerTagService;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 客户标签
 *
 * @author yangshan
 * @date 2021-3-4 11:33:15
 */
@Slf4j
@RestController
@RequestMapping("/mdmCustomerTagController")
@Api(tags = "客户画像")
public class MdmCustomerTagController {

    @Autowired
    private MdmCustomerTagService mdmCustomerTagService;

    @ApiOperation(value = "根据客户编码查询对应标签")
    @PostMapping("/findList")
    @CrmDictMethod
    public Result<List<MdmCustomerTagRespVo>> findList(@RequestBody MdmCustomerTagReqVo  reqVo){
        AssertUtils.isNotEmpty(reqVo.getClientCode(), "客户编码不能为空");
        List<MdmCustomerTagRespVo> list = mdmCustomerTagService.findList(reqVo);
        return Result.ok(list);
    }

    @ApiOperation(value = "新增标签")
    @PostMapping("/save")
    public Result save(@RequestBody MdmCustomerTagReqVo  reqVo) {
        mdmCustomerTagService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "批量新增标签")
    @PostMapping("/saveBatch")
    public Result saveBatch(@RequestBody List<MdmCustomerTagReqVo>  reqVos) {
        mdmCustomerTagService.saveBatch(reqVos);
        return Result.ok();
    }

    @ApiOperation(value = "删除标签", httpMethod = "GET")
    @GetMapping("/delete")
    public Result delete(@RequestParam String id) {
        mdmCustomerTagService.delete(id);
        return Result.ok();
    }

    @ApiOperation(value = "根据标签描述查询客户")
    @PostMapping("/findListByTag")
    @CrmDictMethod
    public Result<List<MdmCustomerTagRespVo>> findListByTag(@RequestBody MdmCustomerTagReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getTagDescription(), "标签描述不能为空");
        List<MdmCustomerTagRespVo> list = mdmCustomerTagService.findList(reqVo);
        return Result.ok(list);
    }

    @ApiOperation(value = "根据终端编/客户编码list查询标签")
    @PostMapping("/queryTagByCodeList")
    @CrmDictMethod
    public Result<List<MdmCustomerTagRespVo>> queryTagByCodeList( @RequestBody List<String> customerCodeList) {
        List<MdmCustomerTagRespVo> mdmCustomerTagRespVos = mdmCustomerTagService.queryTagByCodeList(customerCodeList);
        return Result.ok(mdmCustomerTagRespVos);
    }
}
