package com.biz.crm.customer.controller;


import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customer.service.MdmCustomerTerminalService;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Slf4j
@RestController
@RequestMapping("/mdmcustomerterminal")
@Api(tags = "客户信息：客户终端")
@CrmGlobalLog
public class MdmCustomerTerminalController {

    @Autowired
    private MdmCustomerTerminalService mdmCustomerTerminalService;

    @ApiOperation("新增客户终端关联")
    @PostMapping("/add")
    public Result<Object> correlatedTerminal(@RequestBody MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        mdmCustomerTerminalService.correlatedTerminal(mdmCustomerCorrelatedTerminalReqVo);
        return Result.ok("操作成功");
    }

    @ApiOperation("已关联客户的终端分页")
    @PostMapping("/correlatedCustomerPage")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerTerminalRespVo>> correlatedCustomerPage(@RequestBody MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return Result.ok(mdmCustomerTerminalService.correlatedCustomerPage(mdmCustomerTerminalReqVo));
    }

    @ApiOperation("未关联任何客户的终端分页")
    @PostMapping("/unCorrelatedAnyCustomerPage")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerTerminalRespVo>> unCorrelatedAnyCustomerPage(@RequestBody MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return Result.ok(mdmCustomerTerminalService.unCorrelatedAnyCustomerPage(mdmCustomerTerminalReqVo));
    }

    @ApiOperation("未关联当前客户的终端分页")
    @PostMapping("/unCorrelatedCurrentCustomerPage")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerTerminalRespVo>> unCorrelatedCurrentCustomerPage(@RequestBody MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return Result.ok(mdmCustomerTerminalService.unCorrelatedCurrentCustomerPage(mdmCustomerTerminalReqVo));
    }

    @ApiOperation("根据客户编码和终端编码集合解除上级客户")
    @PostMapping("/unbind")
    public Result<Object> unbind(@RequestBody MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        mdmCustomerTerminalService.unbind(mdmCustomerCorrelatedTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation("替换上级客户")
    @PostMapping("/replaceCustomer")
    public Result<Object> replaceCustomer(@RequestBody MdmCustomerCorrelatedTerminalReplaceReqVo mdmCustomerCorrelatedTerminalReplaceReqVo) {
        mdmCustomerTerminalService.replaceCustomer(mdmCustomerCorrelatedTerminalReplaceReqVo);
        return Result.ok();
    }

    @ApiOperation("模糊查询终端或者客户")
    @PostMapping("/findCustomerTerminalFuzzyList")
    public Result<List<MdmCustomerTerminalFuzzyQueryVo>> findCustomerTerminalFuzzyList(@RequestBody MdmCustomerTerminalFuzzyQueryVo reqVo) {
        return Result.ok(mdmCustomerTerminalService.findCustomerTerminalFuzzyList(reqVo));
    }
}
