package com.biz.crm.customer.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2020-12-29
 **/
public class MdmCustomerProvider {

    public String findListMsg(Map<String,Object> map) {
        MdmCustomerMsgReqVo vo = (MdmCustomerMsgReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL() {{
            SELECT("a.*,c.customer_org_name");
            FROM("mdm_customer a");
            LEFT_OUTER_JOIN("mdm_cus_org c on c.customer_org_code=a.customer_org_code");
            if (StringUtils.isNotEmpty(vo.getCustomerCode())) {
                WHERE(" a.customer_code like " +ProviderUtil.bindPercent(vo.getCustomerCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getCustomerName())) {
                WHERE("a.customer_name like " +ProviderUtil.bindPercent(vo.getCustomerName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getCustomerOrgCode())) {
                WHERE("a.customer_org_code = #{vo.customerOrgCode}");
            }
            if (StringUtils.isNotEmpty(vo.getEnableStatus())) {
                WHERE("a.enable_status = #{vo.enableStatus}");
            }
            if (StringUtils.isNotEmpty(vo.getLockState())) {
                WHERE("a.lock_state = #{vo.lockState}");
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(vo.getCustomerCodeList())) {
                WHERE("customer_code in " + ProviderUtil.gainForeach("(", ",", ")", vo.getCustomerCodeList()));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("a.create_date desc,a.create_date_second desc");
        }}.toString();
    }


}
