package com.biz.crm.customer.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactRespVo;

import java.util.List;

/**
 * 接口
 *
 * @author zxw
 * @date 2020-09-02 14:10:26
 */
public interface MdmCustomerContactService extends IService<MdmCustomerContactEntity> {

    /**
     * 列表
     * @param mdmCustomerContactReqVo
     * @return PageResult<MdmCustomerContactRespVo>
     */
    PageResult<MdmCustomerContactRespVo> findList(MdmCustomerContactReqVo mdmCustomerContactReqVo);

    List<MdmCustomerContactRespVo> list(MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 查询
     * @param mdmCustomerContactReqVo
     * @return MdmCustomerContactRespVo
     */
    MdmCustomerContactRespVo query(MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 新增
     * @param mdmCustomerContactReqVo
     * @return
     */
    void save(MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 更新
     * @param mdmCustomerContactReqVo
     * @return
     */
    void update(MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 删除
     * @param mdmCustomerContactReqVo
     * @return
     */
    void deleteBatch(MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 启用
     * @param mdmCustomerContactReqVo
     * @return
     */
    void enableBatch(MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 禁用
     * @param mdmCustomerContactReqVo
     * @return
     */
    void disableBatch(MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 更新客户与联系人关系
     * @param mdmCustomerContactReqVos 联系人集合
     * @param customerCode 客户编码
     */
    void setUpContact(List<MdmCustomerContactReqVo> mdmCustomerContactReqVos, String customerCode);
}

