package com.biz.crm.customer.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;

import java.util.List;
import java.util.Map;

/**
 * 接口
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
public interface MdmCustomerMsgService extends IService<MdmCustomerEntity> {

    /**
     * 列表
     *
     * @param mdmCustomerMsgReqVo 条件,如果有组织编码，查询当前及下级客户信息
     * @return PageResult<MdmCustomerMsgRespVo>
     */
    PageResult<MdmCustomerMsgRespVo> findList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 条件列表查询
     *
     * @param mdmCustomerMsgReqVo 条件
     * @return 列表
     */
    List<MdmCustomerMsgSelectRespVo> list(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    //产品销售报表
    PageResult<CustomerProductRespVo> findPageList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    //客户销售报表
    PageResult<CustomerSaleRespVo> findCustomerPageList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 查询客户下拉框
     *
     * @param reqVo
     * @return
     */
    List<MdmCustomerMsgSelectRespVo> findCustomerSelectList(MdmCustomerMsgSelectReqVo reqVo);

    /**
     * 获取未关联任何用户的客户（用户管理页面使用）
     *
     * @param mdmCustomerMsgReqVo
     * @return
     */
    List<MdmCustomerMsgSelectRespVo> findCustomerNotRelateUserSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 根据组织编码查询客户信息编码集合
     *
     * @param list 组织编码
     * @return 客户集合编码集合
     */
    List<String> findByOrgCodeList(List<String> list);

    /**
     * 根据职位编码集合查询客户编码集合
     * @param list list
     * @return list
     */
    List<String> findByPositionCodeList(List<String> list);

    /**
     * 查询
     *
     * @param customerCode 客户编码
     * @param id           id
     * @return MdmCustomerMsgRespVo
     */
    MdmCustomerMsgRespVo query(String id, String customerCode);

    /**
     * 根据客户编码查询客户主表信息
     *
     * @param customerCode
     * @return
     */
    MdmCustomerMsgRespVo queryByCustomerCode(String customerCode);

    /**
     * 更新客户信息附属关系，如联系人，销售区域等
     *
     * @param mdmCustomerMsgReqVo
     */
    void setUpCollateral(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 新增
     *
     * @param mdmCustomerMsgReqVo 新增实例
     */
    String save(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 新增并提交流程
     *
     * @param mdmCustomerMsgReqVo 新增实例
     */
    String saveAndSubmit(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 更新
     *
     * @param mdmCustomerMsgReqVo 更新实例
     */
    void update(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 更新并提交
     *
     * @param mdmCustomerMsgReqVo 更新实例
     */
    void updateAndSubmit(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 删除
     *
     * @param mdmCustomerMsgReqVo 条件
     */
    void deleteBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 启用
     *
     * @param mdmCustomerMsgReqVo 条件
     */
    void enableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 禁用
     *
     * @param mdmCustomerMsgReqVo 条件
     */
    void disableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 批量
     *
     * @param mdmCustomerContactReqVos
     */
    void addOrUpdateBatch(List<MdmCustomerContactReqVo> mdmCustomerContactReqVos);


    /**
     * 根据客户编码修改客户组织编码
     *
     * @param mdmUpdateCusOrgCodeReqVo 条件
     */
    void updateOrgCodeByCondition(MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo);

    /**
     * 批量修改客户的企业组织
     *
     * @param reqVo
     */
    void batchUpdateCustomerOrg(MdmOrgCustomerUpdateReqVo reqVo);

    /**
     * 根据客户code集合批量查询客户的组织编码
     *
     * @param customerCodeList 客户编码集合
     * @return result
     */
    Map<String, String> findOrgCodeByCustomerCodeList(List<String> customerCodeList);

    /**
     * 根据客户编码集合查询编码名称Map
     *
     * @param customerCodeList
     * @return
     */
    Map<String, String> findCustomerCodeNameMapByCustomerCodeList(List<String> customerCodeList);

    /**
     * 根据客户code集合批量查询客户的组织编码集合
     *
     * @param customerCodeList 客户编码集合
     * @return result
     */
    Map<String, List<String>> findOrgCodeListByCustomerCodeList(List<String> customerCodeList);

    /**
     * 根据用户编码查询所有客户
     *
     * @param userAccount 用户帐号
     * @return list
     */
    List<String> findAllCustomerCodeByUser(String userAccount);


    /**
     * 根据组织编码集合查询当前及下级组织对应的客户
     *
     * @param mdmCustomerOrgSearchReqVo vo
     * @return list
     */
    List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerAndOrgReqVo mdmCustomerOrgSearchReqVo);

    /**
     * 根据组织编码查询当前及下级组织的客户
     *
     * @param mdmCustomerOrgSearchReqVo vo
     * @return 客户集合
     */
    List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo);

    /**
     * 查询条件编码
     *
     * @param customerCodeConditionReqVo vo
     * @return list
     */
    List<String> findCustomerCodeConditionList(CustomerCodeConditionReqVo customerCodeConditionReqVo);

    /**
     * 根据职位id或职位编码查询客户信息
     *
     * @param mdmPositionCustomerSearchReqVo vo
     * @return list
     */
    List<MdmCustomerMsgRespVo> findPositionCustomerList(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo);

    /**
     * 基本信息查询
     *
     * @param mdmCustomerMsgReqVo vo
     * @return vo
     */
    List<MdmCustomerMsgRespVo> queryBasic(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 查询当前及下级职位对应职位对应的客户集合
     *
     * @param mdmPositionCustomerSearchReqVo vo
     * @return list
     */
    List<MdmCustomerMsgRespVo> findCurrentAndSubPositionCustomer(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo);

    void sendCustomerInsertMsg(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 客户信息变更通知
     *
     * @param customerCodeList 客户编码集合
     */
    void sendCustomerChangeMsg(List<String> customerCodeList);

    /**
     * 分页查询列表及联系人
     *
     * @param mdmCustomerContactPageReqVo vo
     * @return page
     */
    PageResult<MdmCustomerContactPageRespVo> listAndContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo);

    /**
     * 根据客户编码查询对接人列表
     *
     * @param mdmCustomerDockingReqVo vo
     * @return list
     */
    List<MdmCustomerDockingRespVo> dockingList(MdmCustomerDockingReqVo mdmCustomerDockingReqVo);

    /**
     * 根据客户编码集合查询客户分页列表及主联系人
     *
     * @param mdmCustomerContactPageReqVo vo
     * @return page
     */
    PageResult<MdmCustomerContactPageRespVo> customerContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo);

    /**
     * sfa-根据客户编码集合查询客户分页列表及主联系人
     * @param customerCodes
     * @return
     */
    List<MdmCustomerContactPageRespVo> sfaFindCustomerContactPage(List<String> customerCodes);

    /**
     * 根据客户编码集合修改经纬度
     *
     * @param mdmCustomerMsgReqVos 客户编码集合
     */
    void updateCoordinate(List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos);

    /**
     * 根据用户登录名获取用户关联的客户
     *
     * @param userName
     * @return
     */
    List<MdmCustomerMsgRespVo> getCustomerListByUserName(String userName);

    /**
     * 获取客户用户的当前客户
     *
     * @param userName
     * @return
     */
    MdmCustomerMsgRespVo getUserCurrentCustomer(String userName);

    /**
     * 冻结
     *
     * @param ids id集合
     */
    void frozen(List<String> ids);

    /**
     * 解冻
     *
     * @param ids id集合
     */
    void thaw(List<String> ids);

    /**
     * 查询职位关联的客户数量
     *
     * @param positionCode 职位编码
     * @return 数量
     */
    Integer findPositionRelationCustomerCount(String positionCode);


    /**
     * 查询职位关联的客户数量
     *
     * @param positionCode 职位编码
     * @return 数量
     */
    Integer findCurrentPositionRelationCustomerCount(String positionCode);

    /**
     * 条件查询客户主联系人及距离分页列表
     *
     * @param mdmCustomerDistanceContactPageReqVo vo
     * @return page
     */
    PageResult<MdmCustomerContactPageRespVo> distanceContactPage(MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo);

    /**
     *  小程序APP报表客户与拜访 默认今天
     * @param mdmCustomerCountReqVo
     * @return
     */
    MdmCustomerCountRespVo fingCustomerAndVisit(MdmCustomerCountReqVo mdmCustomerCountReqVo);

    /**
     * 流程审批提交
     *
     * @param reqVo
     */
    void submit(MdmCustomerMsgReqVo reqVo);

    /**
     * 流程审批回调
     *
     * @param reqVo
     */
    void callback(ActivitiCallBackVo reqVo);

    /**
     * 状态审批提交
     *
     * @param ids
     */
    void statusApprovalSubmit(List<String> ids);

    /**
     * 状态审批驳回
     *
     * @param ids
     */
    void statusApprovalReject(List<String> ids);

    /**
     * 状态审批通过
     *
     * @param ids
     */
    void statusApprovalAgree(List<String> ids);

    List<MdmTerminalStatisticianTypeVo> statisticalType(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 新增成功 计算绩效和积分
     * @param clientCode
     * @param fromType
     */
    void sendAchievementMsg(String clientCode, String fromType);

    /**
     * 根据客户组织编码集合查询客户组织下的经销商
     *
     * @param customerOrgCodeList
     * @return
     */
    List<MdmCustomerMsgRespVo> findCustomerByCustomerOrgCodeList(List<String> customerOrgCodeList);

    /**
     * 根据经销商编码list查询经销商信息
     * @param customerCodeList
     * @return
     */
    List<MdmCustomerMsgRespVo> queryByCustomerCodeList(List<String> customerCodeList);
}

