package com.biz.crm.customer.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.customer.model.MdmCustomerROrgEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;

import java.util.List;
import java.util.Map;

/**
 * 客户与组织关联表接口
 *
 * @author zxw
 * @date 2020-12-21 09:50:12
 */
public interface MdmCustomerROrgService extends IService<MdmCustomerROrgEntity> {

    Map<String, List<String>> findOrgCodeList(List<String> customerCodeList);

    Map<String, List<MdmOrgRespVo>> findOrgGroupByCustomerCodeList(List<String> customerCodeList);

    List<String> findOrgCodeByCustomerCode(String customerCode);

    /**
     * 根据组织编码查询客户编码集合
     * @param orgCodeList 组织编码集合
     * @return list
     */
    List<String> findCustomerByOrgCodeList(List<String> orgCodeList);

    List<MdmCustomerROrgEntity> findByOrgCodeList(List<String> orgCodeList);

    /**
     * 设置客户与组织关联
     * @param mdmCustomerMsgReqVo 客户
     */
    void setUpOrg(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 批量设置客户的组织
     * @param customerCodeList 客户编码集合
     * @param orgCode 组织
     */
    void setUpOrg(List<String> customerCodeList, String orgCode);

    void replaceOrg(List<String> customerCodeList, String originOrgCode, String orgCode);
}

