package com.biz.crm.customer.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.customer.model.MdmCustomerTagEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTagReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTagRespVo;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 客户标签接口
 *
 * @author yangshan
 * @date 2021-3-4 11:52:44
 */
public interface MdmCustomerTagService extends IService<MdmCustomerTagEntity> {

    /**
     * 列表
     * @param reqVo
     * @return
     */
    List<MdmCustomerTagRespVo> findList(MdmCustomerTagReqVo reqVo);

    /**
     * 新增
     * @param reqVo
     */
    void save(MdmCustomerTagReqVo reqVo);

    /**
     * 批量新增
     * @param reqVos
     */
    void saveBatch(List<MdmCustomerTagReqVo>  reqVos);
    /**
     * 删除
     * @param id
     */
    void delete(String id);

    /**
     * 根据终端编/客户编码list查询标签
     * @param customerCodeList
     * @return
     */
    List<MdmCustomerTagRespVo> queryTagByCodeList(List<String> customerCodeList);
}

