package com.biz.crm.customer.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.MdmCustomerMediaMapper;
import com.biz.crm.customer.model.MdmCustomerMediaEntity;
import com.biz.crm.customer.service.MdmCustomerMediaService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerUploadVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 客户主数据接口实现
 *
 * @author zxw
 * @date 2021-05-10 12:08:41
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="MdmCustomerMediaServiceExpandImpl")
public class MdmCustomerMediaServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<MdmCustomerMediaMapper, MdmCustomerMediaEntity> implements MdmCustomerMediaService {

    @Autowired
    private MdmCustomerMediaMapper mdmCustomerMediaMapper;

    private static final Integer URL_TYPE_CERTIFICATE = 1;

    private static final Integer URL_TYPE_CORPORATE = 2;

    @Override
    public void setUpMedia(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
        if(!StringUtils.isEmpty(customerCode)){
            this.lambdaUpdate()
                    .eq(MdmCustomerMediaEntity::getCustomerCode, customerCode)
                    .remove();
            List<MdmCustomerMediaEntity> certificateImageEntities = setUpCertificateImage(mdmCustomerMsgReqVo);
            List<MdmCustomerMediaEntity>  corporateEntities = setUpCorporateImage(mdmCustomerMsgReqVo);
            if(!CollectionUtils.isEmpty(certificateImageEntities)||!CollectionUtils.isEmpty(corporateEntities)){
                List<MdmCustomerMediaEntity> list = new ArrayList<>(certificateImageEntities.size()+corporateEntities.size());
                list.addAll(certificateImageEntities);
                list.addAll(corporateEntities);
                this.saveBatch(list);
            }
        }
    }

    protected List<MdmCustomerMediaEntity> setUpCertificateImage(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List<String> certificateImageList = mdmCustomerMsgReqVo.getCertificateImageList();
        if(CollectionUtils.isEmpty(certificateImageList)){
            return Collections.emptyList();
        }
        return certificateImageList.stream()
                .filter(x -> !StringUtils.isEmpty(x))
                .map(x -> {
                    MdmCustomerMediaEntity mdmCustomerMediaEntity = new MdmCustomerMediaEntity();
                    mdmCustomerMediaEntity.setCustomerCode(mdmCustomerMsgReqVo.getCustomerCode());
                    mdmCustomerMediaEntity.setUrl(x);
                    mdmCustomerMediaEntity.setUrlType(URL_TYPE_CERTIFICATE);
                    return mdmCustomerMediaEntity;
                })
                .collect(Collectors.toList());
    }

    protected List<MdmCustomerMediaEntity> setUpCorporateImage(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List<MdmCustomerUploadVo> corporateIdentityImageList = mdmCustomerMsgReqVo.getCorporateIdentityImageList();
        if(CollectionUtils.isEmpty(corporateIdentityImageList)){
            return Collections.emptyList();
        }
        return corporateIdentityImageList.stream()
                .filter(x -> !StringUtils.isEmpty(x.getFileName())&&!StringUtils.isEmpty(x.getUrl()))
                .map(x -> {
                    MdmCustomerMediaEntity mdmCustomerMediaEntity = new MdmCustomerMediaEntity();
                    mdmCustomerMediaEntity.setCustomerCode(mdmCustomerMsgReqVo.getCustomerCode());
                    mdmCustomerMediaEntity.setUrlType(URL_TYPE_CORPORATE);
                    mdmCustomerMediaEntity.setFileName(x.getFileName());
                    mdmCustomerMediaEntity.setUrl(x.getUrl());
                    return mdmCustomerMediaEntity;
                })
                .collect(Collectors.toList());
    }

    @Override
    public void setUpCustomer(MdmCustomerMsgRespVo mdmCustomerMsgRespVo) {
        String customerCode = mdmCustomerMsgRespVo.getCustomerCode();
        if(StringUtils.isEmpty(customerCode)){
            return;
        }
        List<MdmCustomerMediaEntity> list = this.lambdaQuery()
                .eq(MdmCustomerMediaEntity::getCustomerCode, customerCode)
                .list();
        if(!CollectionUtils.isEmpty(list)){
            List<String> certificateList = list.stream()
                    .filter(x -> URL_TYPE_CERTIFICATE.equals(x.getUrlType()))
                    .map(MdmCustomerMediaEntity::getUrl)
                    .collect(Collectors.toList());
            mdmCustomerMsgRespVo.setCertificateImageList(certificateList);
            List<MdmCustomerUploadVo> corporateList = list.stream()
                    .filter(x -> URL_TYPE_CORPORATE.equals(x.getUrlType()))
                    .map(x -> {
                        MdmCustomerUploadVo mdmCustomerUploadVo = new MdmCustomerUploadVo();
                        mdmCustomerUploadVo.setId(x.getId());
                        mdmCustomerUploadVo.setCustomerCode(x.getCustomerCode());
                        mdmCustomerUploadVo.setFileName(x.getFileName());
                        mdmCustomerUploadVo.setUrl(x.getUrl());
                        return mdmCustomerUploadVo;
                    }).collect(Collectors.toList());
            mdmCustomerMsgRespVo.setCorporateIdentityImageList(corporateList);
        }
    }
}
