package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.cusorg.service.MdmCusOrgService;
import com.biz.crm.customer.event.CustomerChangeEvent;
import com.biz.crm.customer.manager.MdmCustomerMsgBuilder;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.mapper.MdmCustomerSupplyMapper;
import com.biz.crm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.model.MdmCustomerROrgEntity;
import com.biz.crm.customer.model.MdmCustomerSaleAreaEntity;
import com.biz.crm.customer.service.*;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserCustomerEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserEditReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerRelUserRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelCustomerRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.sfa.visitdealer.SfaVisitDealerDetailFeign;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.service.MdmTerminalElasticsearchService;
import com.biz.crm.user.service.MdmCustomerUserService;
import com.biz.crm.user.service.MdmUserRelCustomerService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 接口实现
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmCustomerMsgServiceExpandImpl")
public class MdmCustomerMsgServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmCustomerMsgMapper, MdmCustomerEntity> implements MdmCustomerMsgService {

    private static final int INITIAL_CAPACITY = 16;
    private static final int PARTITION_SIZE = 500;
    @Autowired
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Autowired
    private MdmCustomerContactService mdmCustomerContactService;
    @Autowired
    private MdmOrgService mdmOrgService;
    @Autowired
    private MdmCustomerSaleAreaService mdmCustomerSaleAreaService;
    @Autowired
    private MdmPositionService mdmPositionService;
    @Autowired
    private MdmCustomerSupplyService mdmCustomerSupplyService;
    @Value("${rocketmq.topic}" + "${rocketmq.environment-variable}")
    private String topic;
    @Autowired
    private RocketMQProducer rocketMQProducer;
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Autowired
    private MdmCustomerBillService mdmCustomerBillService;
    @Autowired
    private SfaVisitDealerDetailFeign sfaVisitDealerDetailFeign;
    @Autowired
    private TaActBaseFeign taActBaseFeign;

    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private MdmTerminalElasticsearchService elasticsearchService;
    @Autowired
    private MdmTerminalMapper mdmTerminalMapper;
    @Autowired
    private MdmUserRelCustomerService mdmUserRelCustomerService;
    @Autowired
    private MdmCustomerMediaService mdmCustomerMediaService;

    @Autowired
    private MdmCustomerUserService mdmCustomerUserService;
    @Autowired
    private MdmCustomerSupplyMapper mdmCustomerSupplyMapper;

    @Autowired
    private MdmCusOrgService mdmCusOrgService;
    @Resource
    private ApplicationContext applicationContext;


    @Override
    public PageResult<MdmCustomerMsgRespVo> findList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Page<MdmCustomerMsgRespVo> page = PageUtil.buildPage(mdmCustomerMsgReqVo.getPageNum(), mdmCustomerMsgReqVo.getPageSize());
        if (!StringUtils.isEmpty(mdmCustomerMsgReqVo.getCode())) {
            List<String> orgCodeList = mdmOrgService.findAllChildrenOrgCodeList(null, mdmCustomerMsgReqVo.getCode());
            mdmCustomerMsgReqVo.setOrgCodeList(orgCodeList);
        } else if (!StringUtils.isEmpty(mdmCustomerMsgReqVo.getOrgCode())) {
            mdmCustomerMsgReqVo.setOrgCodeList(Collections.singletonList(mdmCustomerMsgReqVo.getOrgCode()));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(mdmCustomerMsgReqVo.getAllUnderOrgCodeListIncludeSelf())) {
            List<String> listIncludeSelf = OrgUtil.getChildrenOrgCodeListIncludeSelf(mdmCustomerMsgReqVo.getAllUnderOrgCodeListIncludeSelf());
            if (CollectionUtil.listNotEmptyNotSizeZero(listIncludeSelf)) {
                mdmCustomerMsgReqVo.setAllUnderOrgCodeListIncludeSelf(listIncludeSelf);
            }
        }

        if (StringUtils.isNotEmpty(mdmCustomerMsgReqVo.getChannelName())) {
            List<String> channelList = DictUtil.list(DictConstant.CHANNEL).stream().filter(x -> x.getDictValue().contains(mdmCustomerMsgReqVo.getChannelName())).map(x -> x.getDictCode()).distinct().collect(Collectors.toList());
            if (channelList.isEmpty()) {
                return PageResult.<MdmCustomerMsgRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
            }
            mdmCustomerMsgReqVo.setChannelList(channelList);
        }

        List<MdmCustomerMsgRespVo> list = mdmCustomerMsgMapper.findList(page,
                mdmCustomerMsgReqVo);
        setUpOrgName(list);
        return PageResult.<MdmCustomerMsgRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 设置客户信息的组织
     *
     * @param list 客户信息集合
     */
    protected void setUpOrgName(List<MdmCustomerMsgRespVo> list) {
        if (!CollectionUtils.isEmpty(list)) {
            List<String> customerCodeList = list.stream().filter(x -> !StringUtils.isEmpty(x.getCustomerCode()))
                    .map(MdmCustomerMsgRespVo::getCustomerCode)
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(customerCodeList)) {
                Map<String, List<String>> customerOrgMap = mdmCustomerROrgService.findOrgCodeList(customerCodeList);
                if (!ObjectUtils.isEmpty(customerOrgMap)) {
                    List<String> orgCodeList = customerOrgMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
                    Map<String, String> orgNameMap = mdmOrgService.findOrgNameMap(orgCodeList);
                    if (!ObjectUtils.isEmpty(orgNameMap)) {
                        for (MdmCustomerMsgRespVo mdmCustomerMsgRespVo : list) {
                            List<String> currentOrgCodeList = customerOrgMap.get(mdmCustomerMsgRespVo.getCustomerCode());
                            if (!CollectionUtils.isEmpty(currentOrgCodeList)) {
                                String orgName = currentOrgCodeList.stream()
                                        .filter(x -> !StringUtils.isEmpty(x))
                                        .distinct()
                                        .map(orgNameMap::get)
                                        .collect(Collectors.joining(","));
                                mdmCustomerMsgRespVo.setOrgName(orgName);
                                mdmCustomerMsgRespVo.setOrgCode(currentOrgCodeList.stream()
                                        .filter(x -> !StringUtils.isEmpty(x))
                                        .distinct()
                                        .collect(Collectors.joining(",")));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> list(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Page<MdmCustomerMsgSelectRespVo> page = PageUtil.buildPage(mdmCustomerMsgReqVo.getPageNum(), mdmCustomerMsgReqVo.getPageSize());
        page.setSearchCount(false);
        List<MdmCustomerMsgSelectRespVo> list = mdmCustomerMsgMapper.list(mdmCustomerMsgReqVo, page);
        if (list.size() > 0 && YesNoEnum.yesNoEnum.Y.getValue().equals(mdmCustomerMsgReqVo.getIsQueryCustomerOrgList())) {
            final Map<String, List<MdmOrgRespVo>> orgGroupByCustomerCodeList = mdmCustomerROrgService.findOrgGroupByCustomerCodeList(list.stream().map(MdmCustomerMsgSelectRespVo::getCustomerCode).collect(Collectors.toList()));
            if (!orgGroupByCustomerCodeList.isEmpty()) {
                list.forEach(x -> {
                    x.setOrgList(orgGroupByCustomerCodeList.get(x.getCustomerCode()));
                });
            }
        }
        return list;
    }

    //产品销售报表
    @Override
    public PageResult<CustomerProductRespVo> findPageList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Page<CustomerProductRespVo> page = PageUtil.buildPage(mdmCustomerMsgReqVo.getPageNum(),mdmCustomerMsgReqVo.getPageSize());
        List<CustomerProductRespVo> pageList = mdmCustomerMsgMapper.findPageList(page, mdmCustomerMsgReqVo);
        for (CustomerProductRespVo l : pageList) {
            if (StringUtils.isNotEmpty(l.getUpdateDateAll())){
                l.setUpdateDateAll(l.getUpdateDateAll().substring(0,7));
            }
        }
        return PageResult.<CustomerProductRespVo>builder()
                .data(pageList)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<CustomerSaleRespVo> findCustomerPageList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (StringUtils.isEmpty(mdmCustomerMsgReqVo.getCreateDate())){
            String s = DateUtil.yyyy_MM.format(new Date());
            mdmCustomerMsgReqVo.setCreateDate(s);
        }
        Date date = DateUtil.str2Date(mdmCustomerMsgReqVo.getCreateDate(), DateUtil.yyyy_MM);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH,-1);
        mdmCustomerMsgReqVo.setLastTime(DateUtil.yyyy_MM.format(calendar.getTime()));
        Page<CustomerSaleRespVo> page = PageUtil.buildPage(mdmCustomerMsgReqVo.getPageNum(),mdmCustomerMsgReqVo.getPageSize());
        List<CustomerSaleRespVo> list = mdmCustomerMsgMapper.findCustomerPageList(page, mdmCustomerMsgReqVo);
        for (CustomerSaleRespVo l : list) {
            if (StringUtils.isNotEmpty(l.getCreateDate())){
                l.setCreateDate(l.getCreateDate().substring(0,7));
            }

        }
        return PageResult.<CustomerSaleRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerSelectList(MdmCustomerMsgSelectReqVo reqVo) {
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue(ParameterParam.SELECT_BOX_OPTION_SIZE));
        }
        List<MdmCustomerMsgSelectRespVo> list = new ArrayList<>();
        Set<String> codeList = new HashSet<>(16);
        if (StringUtils.isNotEmpty(reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList<>(codeList));
        }
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        if (pageSize > 0) {
            list.addAll(mdmCustomerMsgMapper.findCustomerSelectList(new Page<>(1L, pageSize, false), reqVo, null, null));
        }
        return list;
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerNotRelateUserSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        return mdmCustomerMsgMapper.findCustomerNotRelateUserSelectList(null, mdmCustomerMsgReqVo);
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return mdmCustomerMsgMapper.findByOrgCodeList(list);
    }

    @Override
    public List<String> findByPositionCodeList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return mdmCustomerMsgMapper.findByPositionCodeList(list);
    }

    @Override
    public MdmCustomerMsgRespVo query(String id, String customerCode) {
        if (StringUtils.isEmpty(id) && StringUtils.isEmpty(customerCode)) {
            return null;
        }
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setCustomerCode(customerCode);
        mdmCustomerMsgReqVo.setId(id);
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = mdmCustomerMsgMapper.query(mdmCustomerMsgReqVo);
        return Optional.ofNullable(mdmCustomerMsgRespVo)
                .map(x -> {
                    setUpCustomer(mdmCustomerMsgRespVo);
                    setUpOrgName(Collections.singletonList(mdmCustomerMsgRespVo));
                    setCustomerUserList(mdmCustomerMsgRespVo);
                    return mdmCustomerMsgRespVo;
                })
                .orElse(null);
    }

    @Override
    public MdmCustomerMsgRespVo queryByCustomerCode(String customerCode) {
        if (StringUtils.isNotEmpty(customerCode)) {
            MdmCustomerEntity one = this.lambdaQuery()
                    .eq(MdmCustomerEntity::getCustomerCode, customerCode)
                    .one();
            if (one != null) {
                MdmCustomerMsgRespVo respVo = CrmBeanUtil.copy(one, MdmCustomerMsgRespVo.class);
                return respVo;
            }
        }
        return null;
    }

    /**
     * 设置对接人与联系人
     *
     * @param mdmCustomerMsgRespVo 转换对象
     */
    protected void setUpCustomer(MdmCustomerMsgRespVo mdmCustomerMsgRespVo) {
        String customerCode = mdmCustomerMsgRespVo.getCustomerCode();
        mdmCustomerMsgRespVo.setMdmCustomerContactVos(mdmCustomerContactService.list(new MdmCustomerContactReqVo().setCustomerCode(customerCode)));
        mdmCustomerMsgRespVo.setMdmCustomerDockingVos(mdmCustomerSupplyService.findDockingListByCustomerCode(new MdmCustomerDockingReqVo().setCustomerCode(customerCode)));
        mdmCustomerMsgRespVo.setMdmCustomerSaleAreaVos(mdmCustomerSaleAreaService.listCondition(new MdmCustomerSaleAreaReqVo().setCustomerCode(customerCode)));
        mdmCustomerMsgRespVo.setMdmCustomerBillVos(mdmCustomerBillService.listCondition(customerCode));
        mdmCustomerMediaService.setUpCustomer(mdmCustomerMsgRespVo);
    }

    /**
     * 设置外部用户
     *
     * @param mdmCustomerMsgRespVo 转换对象
     */
    protected void setCustomerUserList(MdmCustomerMsgRespVo mdmCustomerMsgRespVo) {
        String customerCode = mdmCustomerMsgRespVo.getCustomerCode();
        List<String> userNameList = mdmUserRelCustomerService.findUserNameListByCustomerCode(customerCode);
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            mdmCustomerMsgRespVo.setCustomerUserList(mdmUserService.queryBatchByUserNameList(userNameList)
                    .stream().filter(x -> CrmEnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus()))
                    .map(x -> CrmBeanUtil.copy(x, MdmCustomerRelUserRespVo.class))
                    .collect(Collectors.toList()));
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void setUpCollateral(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        mdmCustomerContactService.setUpContact(mdmCustomerMsgReqVo.getMdmCustomerContactVos(), mdmCustomerMsgReqVo.getCustomerCode());
        mdmCustomerSupplyService.setUpDocking(mdmCustomerMsgReqVo);
        mdmCustomerSaleAreaService.setUpArea(mdmCustomerMsgReqVo.getMdmCustomerSaleAreaVos(), mdmCustomerMsgReqVo.getCustomerCode());
        mdmCustomerBillService.setUp(mdmCustomerMsgReqVo);
        mdmCustomerROrgService.setUpOrg(mdmCustomerMsgReqVo);
        mdmCustomerMediaService.setUpMedia(mdmCustomerMsgReqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String save(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (StringUtils.isNotEmpty(mdmCustomerMsgReqVo.getActApproveStatus())) {
            //TODO 其它地方会传其它的值，临时解决一下
            if (ActApproveStatusEnum.CREATE.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.SUBMIT.getValue());
            }
            if (ActApproveStatusEnum.APPROVING.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
            }
            if (ActApproveStatusEnum.APPROVED.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            }
            if (ActApproveStatusEnum.REJECTED.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
            }
            if (ActApproveStatusEnum.INTERRUPT.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.RECOVER.getValue());
            }
            if (ActApproveStatusEnum.CLOSED.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.CLOSE.getValue());
            }
        }
        if (StringUtils.isEmpty(mdmCustomerMsgReqVo.getActApproveStatus()) || !MdmBpmStatusEnum.PASS.getValue().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
            if (StringUtils.isNotEmpty(mdmCustomerMsgReqVo.getApprovalBusinessCode())) {
                ApprovalType approvalType = ApprovalConfigUtil.checkAndGet(mdmCustomerMsgReqVo.getApprovalBusinessCode(), mdmCustomerMsgReqVo);
                mdmCustomerMsgReqVo.setApprovalType(approvalType.getValue());
                if (approvalType == ApprovalType.NULL) {
                    mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
                } else {
                    mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.SUBMIT.getValue());
                }
            }
        }
        if (StringUtils.isEmpty(mdmCustomerMsgReqVo.getApprovalType())) {
            mdmCustomerMsgReqVo.setApprovalType(ApprovalType.NULL.getValue());
            mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        }
        MdmCustomerMsgBuilder.builder(true, this, mdmUserService)
                .init(mdmCustomerMsgReqVo)
                .valid()
                .convert()
                .persistence()
                .after();

        // 自动生成一条客户用户信息
        if(YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue(ParameterParam.CUSTOMER_CREATE_CUSTOMER_USER_AUTOMATIC))){
            this.createCustomerUserAutomatic(mdmCustomerMsgReqVo);
        }

        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        if (menuCodeObj != null) {
            crmLogSendUtil.sendForAdd(menuCodeObj.toString(), mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getCustomerCode(), CrmBeanUtil.copy(mdmCustomerMsgReqVo, MdmCustomerMsgRespVo.class));
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
            /// 新增发送到es，需要设置ID
            elasticsearchService.add(mdmCustomerMsgReqVo);
        }

        customerChangeSendEvent(CustomerChangeHandlerReqVo.builder()
                .currentOrgCode(mdmCustomerMsgReqVo.getOrgCode())
                .customerCode(mdmCustomerMsgReqVo.getCustomerCode())
                .build());
        return mdmCustomerMsgReqVo.getCustomerCode();

    }

    /**
     * 自动生成一条客户用户信息
     * @param reqVo
     */
    private void createCustomerUserAutomatic(MdmCustomerMsgReqVo reqVo) {
        MdmUserEditReqVo userEditReqVo = new MdmUserEditReqVo();

        // 默认为客户用户
        userEditReqVo.setCustomerCode(reqVo.getCustomerCode());
        userEditReqVo.setUserType(UserTypeEnum.CUSTOMER.getCode());
        userEditReqVo.setFullName(reqVo.getCustomerName());
        userEditReqVo.setGender("0");
        userEditReqVo.setUserPhone(reqVo.getCustomerContact());
        userEditReqVo.setUserName(reqVo.getCustomerCode());
        userEditReqVo.setUserPassword("123456");
        userEditReqVo.setStartTime(DateUtil.getFormatDateStr(new Date(),DateUtil.DEFAULT_DATE_ALL_PATTERN));
        userEditReqVo.setEndTime("2099-01-01 00:00:00");
        userEditReqVo.setCustomerCode(reqVo.getCustomerCode());
        List<MdmUserCustomerEditReqVo> customerList = new ArrayList<>();
        MdmUserCustomerEditReqVo customerEditReqVo = new MdmUserCustomerEditReqVo();
        customerEditReqVo.setCustomerCode(reqVo.getCustomerCode());
        customerList.add(customerEditReqVo);
        userEditReqVo.setCustomerList(customerList);
        mdmCustomerUserService.save(userEditReqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String saveAndSubmit(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        String approvalBusinessCode = mdmCustomerMsgReqVo.getApprovalBusinessCode();
        Assert.hasText(approvalBusinessCode, "缺失审批配置业务编码，不能自动发起");
        MdmApprovalConfigVo config = ApprovalConfigUtil.getConfig(approvalBusinessCode);
        String customerCode = this.save(mdmCustomerMsgReqVo);
        MdmCustomerEntity customer = this.lambdaQuery()
                .eq(MdmCustomerEntity::getCustomerCode, customerCode)
                .one();
        if (MdmBpmStatusEnum.SUBMIT.getValue().equals(customer.getActApproveStatus())) {
            if (ApprovalType.STATUS.getValue().equals(customer.getApprovalType())) {
                this.lambdaUpdate()
                        .eq(MdmCustomerEntity::getCustomerCode, customerCode)
                        .set(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.APPROVAL.getValue())
                        .update();
            }
            if (ApprovalType.BPM.getValue().equals(customer.getApprovalType())) {
                String workFlowKey = mdmCustomerMsgReqVo.getWorkFlowKey();
                if (StringUtils.isEmpty(workFlowKey)) {
                    Assert.notNull(config, "未找到审批配置");
                    Assert.hasText(config.getDefaultWorkFlowKey(), "审批配置缺失流程key");
                    workFlowKey = config.getDefaultWorkFlowKey();
                }
                UserRedis user = UserUtils.getUser();
                StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
                startProcessReqVo.setCallBackFeign("MdmCustomerCallBackFeign");
                startProcessReqVo.setProcessKey(workFlowKey);
                startProcessReqVo.setUserCode(user.getUsername());
                startProcessReqVo.setPosCode(user.getPoscode());
                startProcessReqVo.setTitle(StringUtils.isNotEmpty(mdmCustomerMsgReqVo.getTitle()) ? mdmCustomerMsgReqVo.getTitle() : "客户新增默认提交流程");
                startProcessReqVo.setFormNo(customer.getId());
                startProcessReqVo.setRemark(StringUtils.isNotEmpty(mdmCustomerMsgReqVo.getApproveRemarks()) ? mdmCustomerMsgReqVo.getApproveRemarks() : "");
                startProcessReqVo.setFormType(StringUtils.isNotEmpty(mdmCustomerMsgReqVo.getFromType()) ? mdmCustomerMsgReqVo.getFromType() : "MDM");
                startProcessReqVo.setCostType("customer");
                startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
                startProcessReqVo.setBusinessCode(customer.getCustomerCode());
                startProcessReqVo.setFileList(CollectionUtil.listNotEmptyNotSizeZero(mdmCustomerMsgReqVo.getActivityFileList()) ? mdmCustomerMsgReqVo.getActivityFileList() : null);
                String processNo = ActivityUtils.startProcess(startProcessReqVo);
                this.lambdaUpdate()
                        .eq(MdmCustomerEntity::getCustomerCode, customerCode)
                        .set(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.APPROVAL.getValue())
                        .set(MdmCustomerEntity::getProcessCode, processNo)
                        .update();
            }
        }
        return customerCode;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgRespVo oldObject = this.query(mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getCustomerCode());
        Assert.notNull(oldObject, "未找到指定数据");
        MdmCustomerMsgBuilder.builder(false, this, mdmUserService)
                .init(mdmCustomerMsgReqVo)
                .valid()
                .convert()
                .persistence()
                .after();
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        MdmCustomerMsgRespVo newObject = this.query(mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getCustomerCode());
        if (menuCodeObj != null) {
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getId(), oldObject, newObject);
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
            // 编辑发送，需要带上ID和职位编码，但是编辑一定是带上的
            elasticsearchService.add(mdmCustomerMsgReqVo);
        }

        customerChangeSendEvent(CustomerChangeHandlerReqVo.builder()
                .currentOrgCode(newObject.getOrgCode())
                .oldOrgCode(oldObject.getOrgCode())
                .customerCode(oldObject.getCustomerCode())
                .build());
    }



    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateAndSubmit(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.update(mdmCustomerMsgReqVo);
        String terminalCode = mdmCustomerMsgReqVo.getCustomerCode();
        MdmCustomerEntity terminal = this.lambdaQuery()
                .eq(MdmCustomerEntity::getCustomerCode, terminalCode)
                .one();
        if (MdmBpmStatusEnum.SUBMIT.getValue().equals(terminal.getActApproveStatus()) || MdmBpmStatusEnum.RECOVER.getValue().equals(terminal.getActApproveStatus()) || MdmBpmStatusEnum.REJECT.getValue().equals(terminal.getActApproveStatus())) {
            if (ApprovalType.STATUS.getValue().equals(terminal.getApprovalType())) {
                this.lambdaUpdate()
                        .eq(MdmCustomerEntity::getCustomerCode, terminalCode)
                        .set(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.APPROVAL.getValue())
                        .update();
            } else if (ApprovalType.BPM.getValue().equals(terminal.getApprovalType())) {
                Assert.hasText(mdmCustomerMsgReqVo.getApprovalBusinessCode(), "缺失审批配置编码");

                String workFlowKey = mdmCustomerMsgReqVo.getWorkFlowKey();
                if (StringUtils.isEmpty(workFlowKey)) {
                    MdmApprovalConfigVo config = ApprovalConfigUtil.getConfig(mdmCustomerMsgReqVo.getApprovalBusinessCode());
                    Assert.notNull(config, "未找到审批配置编码" + mdmCustomerMsgReqVo.getApprovalBusinessCode());
                    Assert.hasText(config.getDefaultWorkFlowKey(), "审批配置未配置默认流程key");
                    workFlowKey = config.getDefaultWorkFlowKey();
                }
                UserRedis user = UserUtils.getUser();
                StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
                startProcessReqVo.setCallBackFeign("MdmCustomerCallBackFeign");
                startProcessReqVo.setProcessKey(workFlowKey);
                startProcessReqVo.setUserCode(user.getUsername());
                startProcessReqVo.setPosCode(user.getPoscode());
                startProcessReqVo.setTitle(StringUtils.isNotEmpty(mdmCustomerMsgReqVo.getTitle()) ? mdmCustomerMsgReqVo.getTitle() : "客户编辑默认提交流程");
                startProcessReqVo.setFormNo(terminal.getId());
                startProcessReqVo.setRemark(StringUtils.isNotEmpty(mdmCustomerMsgReqVo.getApproveRemarks()) ? mdmCustomerMsgReqVo.getApproveRemarks() : "");
                startProcessReqVo.setFormType(StringUtils.isNotEmpty(mdmCustomerMsgReqVo.getFromType()) ? mdmCustomerMsgReqVo.getFromType() : "MDM");
                startProcessReqVo.setCostType("customer");
                startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
                startProcessReqVo.setBusinessCode(terminal.getCustomerCode());
                startProcessReqVo.setFileList(CollectionUtil.listNotEmptyNotSizeZero(mdmCustomerMsgReqVo.getActivityFileList()) ? mdmCustomerMsgReqVo.getActivityFileList() : null);
                String no = ActivityUtils.startProcess(startProcessReqVo);

                this.lambdaUpdate()
                        .eq(MdmCustomerEntity::getCustomerCode, terminalCode)
                        .set(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.APPROVAL.getValue())
                        .set(MdmCustomerEntity::getProcessCode, no)
                        .update();

            } else {
                this.lambdaUpdate()
                        .eq(MdmCustomerEntity::getCustomerCode, terminalCode)
                        .set(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                        .update();

            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List<String> ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty(ids, "id集合不能为空");
        List<MdmCustomerEntity> list = this.lambdaQuery()
                .in(MdmCustomerEntity::getId, ids)
                .list();
        Assert.notEmpty(list, "客户不存在");
        List<String> customerCodeList = list.stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getCustomerCode()))
                .map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        List<String> sendCustomerCodeList = list.stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getCustomerCode()) && MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus()))
                .map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            mdmCustomerROrgService.lambdaUpdate()
                    .in(MdmCustomerROrgEntity::getCustomerCode, customerCodeList)
                    .remove();
            mdmCustomerSaleAreaService.lambdaUpdate()
                    .in(MdmCustomerSaleAreaEntity::getCustomerCode, customerCodeList)
                    .remove();
            mdmCustomerSupplyService.removeByCustomerCodeList(customerCodeList);
            mdmCustomerContactService.lambdaUpdate()
                    .in(MdmCustomerContactEntity::getCustomerCode, customerCodeList)
                    .remove();
        }
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        if (menuCodeObj != null) {
            list.forEach(item -> {
                crmLogSendUtil.sendForDel(menuCodeObj.toString(),
                        item.getId(), mdmCustomerMsgReqVo.getCustomerCode(), item);
            });
        }
        this.removeByIds(ids);
        try {
            elasticsearchService.delete(ids);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        sendCustomerChangeMsg(sendCustomerCodeList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List<String> ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty(ids, "id集合不能为空");
        List<MdmCustomerEntity> list = this.lambdaQuery()
                .in(MdmCustomerEntity::getId, ids)
                .eq(MdmCustomerEntity::getEnableStatus, CrmEnableStatusEnum.DISABLE.getCode())
                .select(MdmCustomerEntity::getId, MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getActApproveStatus)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            this.lambdaUpdate()
                    .in(MdmCustomerEntity::getId, mdmCustomerMsgReqVo.getIds())
                    .set(MdmCustomerEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                    .update();
            sendCustomerChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList()));
        }
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        if (menuCodeObj != null) {
            list.forEach(item -> {
                MdmCustomerMsgRespVo oldObject = CrmBeanUtil.copy(item, MdmCustomerMsgRespVo.class);
                oldObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                MdmCustomerMsgRespVo newObject = CrmBeanUtil.copy(item, MdmCustomerMsgRespVo.class);
                newObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getCustomerCode(), oldObject, newObject);
            });
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List<String> ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty(ids, "id集合不能为空");
        List<MdmCustomerEntity> list = this.lambdaQuery()
                .in(MdmCustomerEntity::getId, ids)
                .eq(MdmCustomerEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .select(MdmCustomerEntity::getId, MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getActApproveStatus)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            this.lambdaUpdate()
                    .in(MdmCustomerEntity::getId, mdmCustomerMsgReqVo.getIds())
                    .set(MdmCustomerEntity::getEnableStatus, CrmEnableStatusEnum.DISABLE.getCode())
                    .update();
            sendCustomerChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList()));
        }
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        if (menuCodeObj != null) {
            list.forEach(item -> {
                MdmCustomerMsgRespVo oldObject = CrmBeanUtil.copy(item, MdmCustomerMsgRespVo.class);
                oldObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                MdmCustomerMsgRespVo newObject = CrmBeanUtil.copy(item, MdmCustomerMsgRespVo.class);
                newObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getCustomerCode(), oldObject, newObject);
            });
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addOrUpdateBatch(List<MdmCustomerContactReqVo> mdmCustomerContactReqVos) {
        if (!CollectionUtils.isEmpty(mdmCustomerContactReqVos)) {
            mdmCustomerContactService.saveOrUpdateBatch(CrmBeanUtil.copyList(mdmCustomerContactReqVos, MdmCustomerContactEntity.class));
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateOrgCodeByCondition(MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo) {
        List<String> customerCodeList = mdmUpdateCusOrgCodeReqVo.getCustomerCodeList();
        String customerOrgCode = mdmUpdateCusOrgCodeReqVo.getCustomerOrgCode();
        if (CollectionUtils.isEmpty(customerCodeList) || StringUtils.isEmpty(customerOrgCode)) {
            throw new BusinessException("客户编码集合或客户组织编码不能为空");
        }
        this.lambdaUpdate()
                .in(MdmCustomerEntity::getCustomerCode, customerCodeList)
                .set(MdmCustomerEntity::getCustomerOrgCode, customerOrgCode)
                .update();
        List<String> sendCustomerCodeList = this.lambdaQuery()
                .eq(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                .in(MdmCustomerEntity::getCustomerCode, customerCodeList)
                .select(MdmCustomerEntity::getCustomerCode)
                .list()
                .stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        sendCustomerChangeMsg(sendCustomerCodeList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchUpdateCustomerOrg(MdmOrgCustomerUpdateReqVo reqVo) {
        Assert.notEmpty(reqVo.getCustomerCodeList(), "缺失客户编码");
        Assert.hasText(reqVo.getOrgCode(), "缺失组织编码");
        if (StringUtils.isNotEmpty(reqVo.getOriginOrgCode())) {
            mdmCustomerROrgService.replaceOrg(reqVo.getCustomerCodeList(), reqVo.getOriginOrgCode(), reqVo.getOrgCode());
        } else {
            mdmCustomerROrgService.setUpOrg(reqVo.getCustomerCodeList(), reqVo.getOrgCode());
        }
        List<String> sendCustomerCodeList = this.lambdaQuery()
                .eq(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                .in(MdmCustomerEntity::getCustomerCode, reqVo.getCustomerCodeList())
                .select(MdmCustomerEntity::getCustomerCode)
                .list()
                .stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        sendCustomerChangeMsg(sendCustomerCodeList);
    }

    @Override
    public Map<String, String> findOrgCodeByCustomerCodeList(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Collections.emptyMap();
        }
        List<MdmCustomerEntity> list = this.lambdaQuery()
                .eq(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                .in(MdmCustomerEntity::getCustomerCode, customerCodeList)
                .select(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getOrgCode)
                .list();
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getOrgCode));
    }

    @Override
    public Map<String, String> findCustomerCodeNameMapByCustomerCodeList(List<String> customerCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodeList)) {
            Map<String, String> map = new HashMap<>(INITIAL_CAPACITY);
            List<List<String>> codeList = Lists.partition(customerCodeList, PARTITION_SIZE);
            for (List<String> list :
                    codeList) {
                map.putAll(this.lambdaQuery()
                        .in(MdmCustomerEntity::getCustomerCode, list)
                        .select(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName)
                        .list()
                        .stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName)));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, List<String>> findOrgCodeListByCustomerCodeList(List<String> customerCodeList) {
        return mdmCustomerROrgService.findOrgCodeList(customerCodeList);
//        Map<String, List<String>> map = new HashMap<>();
//        if (CollectionUtils.isEmpty(customerCodeList)) {
//            return Collections.emptyMap();
//        }
//        List<MdmCustomerEntity> list = this.lambdaQuery()
//                .in(MdmCustomerEntity::getCustomerCode, customerCodeList)
//                .select(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getOrgCode)
//                .list();
//        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
//
//            map = list.stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, v -> {
//                List<String> orgCodeList = new ArrayList<>();
//                if (StringUtils.isEmpty(v.getOrgCode())) {
//                    orgCodeList.add(v.getOrgCode());
//                }
//                return orgCodeList;
//            }));
//            List<MdmCustomerSupplyEntity> supplyList = mdmCustomerSupplyService.lambdaQuery()
//                    .in(MdmCustomerSupplyEntity::getCustomerCode, customerCodeList)
//                    .select(MdmCustomerSupplyEntity::getCustomerCode, MdmCustomerSupplyEntity::getOrgCode)
//                    .list();
//            if (CollectionUtil.listNotEmptyNotSizeZero(supplyList)) {
//                Map<String, Set<String>> collect = supplyList.stream().filter(item -> StringUtils.isNotEmpty(item.getOrgCode())).collect(Collectors.groupingBy(MdmCustomerSupplyEntity::getCustomerCode, Collectors.mapping(MdmCustomerSupplyEntity::getOrgCode, Collectors.toSet())));
//                if (!collect.isEmpty()) {
//                    for (Map.Entry<String, List<String>> entry :
//                            map.entrySet()) {
//                        if (collect.containsKey(entry.getKey())) {
//                            Set<String> strings = collect.get(entry.getKey());
//                            strings.addAll(entry.getValue());
//                            entry.setValue(new ArrayList<>(strings));
//                        }
//                    }
//                }
//            }
//        }
//        return map;
    }

    @Override
    public List<String> findAllCustomerCodeByUser(String userAccount) {
        if (StringUtils.isEmpty(userAccount)) {
            return new ArrayList<>();
        }
        return mdmCustomerMsgMapper.findAllCustomerApprovedCodeByUser(userAccount, MdmBpmStatusEnum.PASS.getValue());
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerAndOrgReqVo mdmCustomerOrgSearchReqVo) {
        List<String> orgCodeList = mdmCustomerOrgSearchReqVo.getOrgCodeList();
        List<String> customerCodeList = mdmCustomerOrgSearchReqVo.getCustomerCodeList();
        if (CollectionUtils.isEmpty(orgCodeList) && CollectionUtils.isEmpty(customerCodeList)) {
            return new ArrayList<>();
        }
        List<MdmOrgRespVo> children = new ArrayList<>();
        if (!CollectionUtils.isEmpty(orgCodeList)) {
            children = OrgUtil.getChildrenOrgListIncludeSelfEnable(orgCodeList);
            orgCodeList = CollectionUtils.isEmpty(children) ? null : children.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            mdmCustomerOrgSearchReqVo.setOrgCodeList(orgCodeList);
        }
        List<MdmCustomerMsgRespVo> currentAndSubCustomerList = mdmCustomerMsgMapper.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        currentAndSubCustomerList = currentAndSubCustomerList.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(currentAndSubCustomerList)) {
            return new ArrayList<>();
        }
        List<String> searchCustomerCodeList = currentAndSubCustomerList.stream().map(MdmCustomerMsgRespVo::getCustomerCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(searchCustomerCodeList)) {
            Map<String, List<String>> groupOrgCodeMap = mdmCustomerROrgService.findOrgCodeList(searchCustomerCodeList);
            if (groupOrgCodeMap != null && !groupOrgCodeMap.isEmpty()) {
                List<String> allOrgCodeList = groupOrgCodeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                List<MdmOrgRespVo> mdmOrgRespVos = OrgUtil.getOrgByCodeList(allOrgCodeList);
                for (MdmCustomerMsgRespVo mdmCustomerMsgRespVo : currentAndSubCustomerList) {
                    List<String> currentOrgCodeList = groupOrgCodeMap.get(mdmCustomerMsgRespVo.getCustomerCode());
                    if (CollectionUtils.isEmpty(currentOrgCodeList)) {
                        continue;
                    }
                    mdmCustomerMsgRespVo.setOrgCode(String.join(",", currentOrgCodeList));
                    String orgName = mdmOrgRespVos.stream()
                            .filter(x -> currentOrgCodeList.contains(x.getOrgCode()))
                            .map(MdmOrgRespVo::getOrgName)
                            .collect(Collectors.joining(","));
                    mdmCustomerMsgRespVo.setOrgName(orgName);
                }
            }
        }
        return currentAndSubCustomerList;
    }


    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        Integer pageNum = mdmCustomerOrgSearchReqVo.getPageNum();
        if (pageNum == null) {
            pageNum = 0;
        }
        Integer pageSize = mdmCustomerOrgSearchReqVo.getPageSize();
        if (pageSize == null) {
            pageSize = 5000;
        }
        if (StringUtils.isEmpty(mdmCustomerOrgSearchReqVo.getCustomerOrgCode())) {
            List<String> orgCodeList = mdmCustomerOrgSearchReqVo.getOrgCodeList();
            if (CollectionUtils.isEmpty(orgCodeList)) {
                return new ArrayList<>();
            }
            List<String> subOrgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelf(orgCodeList);
            if (CollectionUtils.isEmpty(subOrgCodeList)) {
                return new ArrayList<>();
            } else {
                mdmCustomerOrgSearchReqVo.setOrgCodeList(subOrgCodeList);
            }
            mdmCustomerOrgSearchReqVo.setOrgCodeList(subOrgCodeList);
        } else {
            mdmCustomerOrgSearchReqVo.setOrgCodeList(null);
            //查询大客户的下级组织类型为大仓的客户组织(恒大需求)
            List<CusOrgVo> childrenCustomerOrgList = CustomerOrgUtil.getChildrenCustomerOrgListIncludeSelf(mdmCustomerOrgSearchReqVo.getCustomerOrgCode());
            if (StringUtils.isNotEmpty(mdmCustomerOrgSearchReqVo.getCustomerOrgLevel())) {
                childrenCustomerOrgList = childrenCustomerOrgList.stream().filter(x -> mdmCustomerOrgSearchReqVo.getCustomerOrgLevel().equals(x.getCustomerOrgLevel())).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty(mdmCustomerOrgSearchReqVo.getCustomerOrgLevelList())) {
                childrenCustomerOrgList = childrenCustomerOrgList.stream().filter(x -> mdmCustomerOrgSearchReqVo.getCustomerOrgLevelList().contains(x.getCustomerOrgLevel())).collect(Collectors.toList());
            }
            if (CollectionUtil.listEmpty(childrenCustomerOrgList)) {
                return new ArrayList<>();
            }
            mdmCustomerOrgSearchReqVo.setCustomerOrgCodeList(childrenCustomerOrgList.stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList()));
        }
        Page<MdmCustomerMsgRespVo> page = new Page<>(pageNum, pageSize);
        mdmCustomerOrgSearchReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        return mdmCustomerMsgMapper.findListByOrgCodeList(page, mdmCustomerOrgSearchReqVo);
    }

    @Override
    public List<String> findCustomerCodeConditionList(CustomerCodeConditionReqVo customerCodeConditionReqVo) {
        if (CollectionUtil.listEmpty(customerCodeConditionReqVo.getChannelList()) && CollectionUtil.listEmpty(customerCodeConditionReqVo.getOrgCodeList())) {
            return Lists.newArrayList();
        }
        List<MdmCustomerEntity> merge = Lists.newArrayList();
        if (!CollectionUtil.listEmpty(customerCodeConditionReqVo.getChannelList())) {
            merge.addAll(this.lambdaQuery()
                    .eq(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                    .in(MdmCustomerEntity::getChannel, customerCodeConditionReqVo.getChannelList())
                    .select(MdmCustomerEntity::getCustomerCode)
                    .list());
        }
        if (!CollectionUtil.listEmpty(customerCodeConditionReqVo.getOrgCodeList())) {
            merge.addAll(this.lambdaQuery()
                    .eq(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                    .in(MdmCustomerEntity::getOrgCode, customerCodeConditionReqVo.getOrgCodeList())
                    .select(MdmCustomerEntity::getCustomerCode)
                    .list());
        }
        return merge.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
    }

    @Override
    public List<MdmCustomerMsgRespVo> findPositionCustomerList(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        mdmPositionCustomerSearchReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        return mdmCustomerMsgMapper.findPositionCustomerList(mdmPositionCustomerSearchReqVo);
    }

    @Override
    public List<MdmCustomerMsgRespVo> queryBasic(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List<MdmCustomerEntity> list = this.lambdaQuery()
                .eq(!StringUtils.isEmpty(mdmCustomerMsgReqVo.getId()), MdmCustomerEntity::getId, mdmCustomerMsgReqVo.getId())
                .eq(!StringUtils.isEmpty(mdmCustomerMsgReqVo.getCustomerCode()), MdmCustomerEntity::getCustomerCode, mdmCustomerMsgReqVo.getCustomerCode())
                .eq(!StringUtils.isEmpty(mdmCustomerMsgReqVo.getEnableStatus()), MdmCustomerEntity::getEnableStatus, mdmCustomerMsgReqVo.getEnableStatus())
                .eq(!StringUtils.isEmpty(mdmCustomerMsgReqVo.getActApproveStatus()), MdmCustomerEntity::getActApproveStatus, mdmCustomerMsgReqVo.getActApproveStatus())
                .list();
        return CrmBeanUtil.copyList(list, MdmCustomerMsgRespVo.class);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubPositionCustomer(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        String positionCode = mdmPositionCustomerSearchReqVo.getPositionCode();
        Assert.hasText(positionCode, "职位编码不能为空");
        mdmPositionCustomerSearchReqVo.setPositionCodeList(mdmPositionService.findAllChildrenPositionCodeList(null, positionCode));
        return findPositionCustomerList(mdmPositionCustomerSearchReqVo);
    }

    @Override
    public void sendCustomerInsertMsg(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        log.info("通知客户信息或客户的组织发生变化,客户编码集合:{}", mdmCustomerMsgReqVo);
        if (mdmCustomerMsgReqVo == null) {
            return;
        }
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(topic);
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.CUSTOMER_INSERT);
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(mdmCustomerMsgReqVo));
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public void sendCustomerChangeMsg(List<String> customerCodeList) {
        log.info("通知客户信息或客户的组织发生变化,客户编码集合:{}", customerCodeList);
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setTopic(topic);
            rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.CUS_AVAILBLELIST_REFRSH);
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(customerCodeList));
            rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> listAndContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        String positionCode = mdmCustomerContactPageReqVo.getPositionCode();
        if (!StringUtils.isEmpty(positionCode) || CollectionUtil.listNotEmptyNotSizeZero(mdmCustomerContactPageReqVo.getPositionCodeList())) {
            List<String> positionCodeList = mdmCustomerContactPageReqVo.getPositionCodeList() != null ? mdmCustomerContactPageReqVo.getPositionCodeList() : new ArrayList<>();
            if (StringUtils.isNotEmpty(mdmCustomerContactPageReqVo.getPositionCode())) {
                if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
                    positionCodeList.retainAll(Collections.singletonList(positionCode));
                } else {
                    positionCodeList.add(positionCode);
                }
            }
            List<String> customerCodeList = mdmCustomerSupplyService.findCustomerCodeByPosition(positionCodeList);
            log.info("客户信息：关联职位的客户:{}", customerCodeList);
            if (CollectionUtils.isEmpty(customerCodeList)) {
                return PageResult.<MdmCustomerContactPageRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
            }
            mdmCustomerContactPageReqVo.setCustomerCodeList(customerCodeList);
        }
        Page<MdmCustomerMsgRespVo> page = PageUtil.buildPage(mdmCustomerContactPageReqVo.getPageNum(), mdmCustomerContactPageReqVo.getPageSize());
        mdmCustomerContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmCustomerContactPageRespVo> mdmCustomerMsgRespVos = mdmCustomerMsgMapper.listAndContactPage(page, mdmCustomerContactPageReqVo);
        mdmCustomerMsgRespVos.stream().forEach(mdm -> mdm.setCustomerCategory("经销商"));
        return PageResult.<MdmCustomerContactPageRespVo>builder()
                .data(mdmCustomerMsgRespVos)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<MdmCustomerDockingRespVo> dockingList(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        Assert.hasText(mdmCustomerDockingReqVo.getCustomerCode(), "客户编码不能为空");
//        return mdmCustomerDockingService.list(mdmCustomerDockingReqVo);
        List<MdmCustomerDockingRespVo> list = mdmCustomerSupplyService.findDockingListByCustomerCode(mdmCustomerDockingReqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list = list.stream().filter(item -> StringUtils.isNotEmpty(item.getUserName())).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> customerContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        Page<MdmCustomerMsgRespVo> page = PageUtil.buildPage(mdmCustomerContactPageReqVo.getPageNum(), mdmCustomerContactPageReqVo.getPageSize());
        mdmCustomerContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<String> positionCodeList = mdmCustomerContactPageReqVo.getPositionCodeList();
        if (!org.springframework.util.CollectionUtils.isEmpty(positionCodeList)) {
            //如果职位有搜索条件，就不走数据权限
            ThreadLocalUtil.delObj();
        }
        List<MdmCustomerContactPageRespVo> mdmCustomerMsgRespVos = mdmCustomerMsgMapper.listAndContactPage(page, mdmCustomerContactPageReqVo);
        return PageResult.<MdmCustomerContactPageRespVo>builder()
                .data(mdmCustomerMsgRespVos)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<MdmCustomerContactPageRespVo> sfaFindCustomerContactPage(List<String> customerCodes) {
        List<MdmCustomerContactPageRespVo> list = new ArrayList<>();
        List<List<String>> cusList = Lists.partition(customerCodes, 500);
        cusList.forEach(cus -> {
            final MdmCustomerContactPageReqVo reqVo = new MdmCustomerContactPageReqVo() {{
                this.setCustomerCodeList(cus);
                this.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            }};
            List<MdmCustomerContactPageRespVo> mdmCustomerMsgRespVos = mdmCustomerMsgMapper.listAndContactPage(null, reqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(mdmCustomerMsgRespVos)) {
                list.addAll(mdmCustomerMsgRespVos);
            }
        });
        return list;
    }

    @Override
    public void updateCoordinate(List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos) {
        if (CollectionUtils.isEmpty(mdmCustomerMsgReqVos)) {
            return;
        }
        for (MdmCustomerMsgReqVo mdmCustomerMsgReqVo : mdmCustomerMsgReqVos) {
            String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
            if (!StringUtils.isEmpty(customerCode)) {
                this.lambdaUpdate()
                        .eq(MdmCustomerEntity::getCustomerCode, customerCode)
                        .set(MdmCustomerEntity::getLongitude, mdmCustomerMsgReqVo.getLongitude())
                        .set(MdmCustomerEntity::getLatitude, mdmCustomerMsgReqVo.getLatitude())
                        .update();
            }
        }
    }

    @Override
    public List<MdmCustomerMsgRespVo> getCustomerListByUserName(String userName) {
        List<MdmCustomerMsgRespVo> list = new ArrayList<>();
        if (StringUtils.isNotEmpty(userName)) {
            List<String> customerCodeList = mdmUserRelCustomerService.findCustomerCodeListByUserName(userName);
            if (CollectionUtil.listEmpty(customerCodeList)) {
                return new ArrayList<>();
            }
            List<MdmCustomerEntity> customerEntityList = this.lambdaQuery()
                    .in(MdmCustomerEntity::getCustomerCode, customerCodeList)
                    .eq(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(customerEntityList)) {
                //缓存客户关联的角色
                return CrmBeanUtil.copyList(customerEntityList, MdmCustomerMsgRespVo.class);
            }
        }
        return list;
    }

    @Override
    public MdmCustomerMsgRespVo getUserCurrentCustomer(String userName) {
        if (StringUtils.isNotEmpty(userName)) {
            List<MdmUserRelCustomerRespVo> userRelCustomerList = mdmUserRelCustomerService.findCustomerListByUserName(userName);
            if (CollectionUtil.listNotEmptyNotSizeZero(userRelCustomerList)) {
                Set<String> collect = userRelCustomerList.stream().map(MdmUserRelCustomerRespVo::getCustomerCode).collect(Collectors.toSet());
                Map<String, MdmCustomerMsgRespVo> customerMap = this.lambdaQuery()
                        .eq(MdmCustomerEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                        .eq(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                        .in(MdmCustomerEntity::getCustomerCode, collect)
                        .list()
                        .stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, v -> CrmBeanUtil.copy(v, MdmCustomerMsgRespVo.class)));
                List<String> currentCodeList = userRelCustomerList.stream().filter(x -> YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getCurrentFlag())).map(MdmUserRelCustomerRespVo::getCustomerCode).collect(Collectors.toList());
                if (currentCodeList.size() == 1 && customerMap.containsKey(currentCodeList.get(0))) {
                    return customerMap.get(currentCodeList.get(0));
                }
                for (MdmUserRelCustomerRespVo userRelCustomer :
                        userRelCustomerList) {
                    if (customerMap.containsKey(userRelCustomer.getCustomerCode())) {
                        mdmUserRelCustomerService.setUniqueCurrentCustomerIfExist(userName, userRelCustomer.getCustomerCode());
                        return customerMap.get(userRelCustomer.getCustomerCode());
                    }
                }
            }
        }
        return null;
    }

    @Override
    public void frozen(List<String> ids) {
        Assert.notEmpty(ids, "id集合不能为空");
        this.lambdaUpdate()
                .in(MdmCustomerEntity::getId, ids)
                .set(MdmCustomerEntity::getLockState, CrmEnableStatusEnum.DISABLE.getCode())
                .update();
    }

    @Override
    public void thaw(List<String> ids) {
        Assert.notEmpty(ids, "id集合不能为空");
        this.lambdaUpdate()
                .in(MdmCustomerEntity::getId, ids)
                .set(MdmCustomerEntity::getLockState, CrmEnableStatusEnum.ENABLE.getCode())
                .update();
    }

    @Override
    public Integer findPositionRelationCustomerCount(String positionCode) {
        if (StringUtils.isEmpty(positionCode)) {
            return 0;
        }
        List<MdmPositionRespVo> position = mdmPositionService.findAllChildrenPositionList(null, positionCode);
        if (CollectionUtils.isEmpty(position)) {
            return 0;
        }
        List<String> positionCodeList = position.stream()
                .filter(x -> !StringUtils.isEmpty(x.getPositionCode()))
                .map(MdmPositionRespVo::getPositionCode)
                .collect(Collectors.toList());
        return mdmCustomerSupplyService.lambdaQuery()
                .in(MdmCustomerSupplyEntity::getPositionCode, positionCodeList)
                .count();
    }

    @Override
    public Integer findCurrentPositionRelationCustomerCount(String positionCode) {
        if (StringUtils.isEmpty(positionCode)) {
            return 0;
        }
        return mdmCustomerSupplyService.lambdaQuery()
                .eq(MdmCustomerSupplyEntity::getPositionCode, positionCode)
                .count();
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> distanceContactPage(MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        Page<MdmCustomerContactPageRespVo> page = PageUtil.buildPage(mdmCustomerDistanceContactPageReqVo.getPageNum(), mdmCustomerDistanceContactPageReqVo.getPageSize());
        List<MdmCustomerContactPageRespVo> list = mdmCustomerMsgMapper.distanceContactPage(page, mdmCustomerDistanceContactPageReqVo);
        return PageResult.<MdmCustomerContactPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


    /**
     * 小程序APP报表客户与拜访 默认今天
     *
     * @param reqVo
     * @return
     */
    @Override
    public MdmCustomerCountRespVo fingCustomerAndVisit(MdmCustomerCountReqVo reqVo) {
        MdmCustomerCountRespVo mdmCustomerCountRespVo = new MdmCustomerCountRespVo();
        if (StringUtils.isEmpty(reqVo.getUserName())) {
            reqVo.setUserName(UserUtils.getUser().getUsername());
            reqVo.setPosCode(UserUtils.getUser().getPoscode());
        }
        if (StringUtils.isEmpty(reqVo.getTimeType())) {
            reqVo.setTimeType(WorkSignEnum.TimeType.JT.getVal());
        }
        if (WorkSignEnum.TimeType.BZ.getVal().equals(reqVo.getTimeType())) {
            getWeekOfDate(reqVo);
        } else if (WorkSignEnum.TimeType.BY.getVal().equals(reqVo.getTimeType())) {
            reqVo.setStartDate(DateUtil.yyyy_MM.format(new Date()) + "-01");
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.set(Calendar.DAY_OF_MONTH, c.getActualMaximum(Calendar.DAY_OF_MONTH));
            Date end = c.getTime();
            reqVo.setEndDate(DateUtil.date_sdf.format(end));

            c.add(Calendar.MONTH, -1);
            reqVo.setThanStartDate(DateUtil.yyyy_MM.format(c.getTime()) + "-01");
            c.set(Calendar.DAY_OF_MONTH, c.getActualMaximum(Calendar.DAY_OF_MONTH));
            Date thanStart = c.getTime();
            reqVo.setThanEndDate(DateUtil.date_sdf.format(thanStart));
        } else if (WorkSignEnum.TimeType.SY.getVal().equals(reqVo.getTimeType())) {
            Calendar c = Calendar.getInstance();
            c.add(Calendar.MONTH, -1);
            reqVo.setStartDate(DateUtil.yyyy_MM.format(c.getTime()) + "-01");
            c.set(Calendar.DAY_OF_MONTH, c.getActualMaximum(Calendar.DAY_OF_MONTH));
            Date end = c.getTime();
            reqVo.setEndDate(DateUtil.date_sdf.format(end));

            c.add(Calendar.MONTH, -1);
            c.set(Calendar.DAY_OF_MONTH, c.getActualMinimum(Calendar.DAY_OF_MONTH));
            reqVo.setThanStartDate(DateUtil.date_sdf.format(c.getTime()));
            c.set(Calendar.DAY_OF_MONTH, c.getActualMaximum(Calendar.DAY_OF_MONTH));
            Date thanStart = c.getTime();
            reqVo.setThanEndDate(DateUtil.date_sdf.format(thanStart));
        } else {
            reqVo.setStartDate(DateUtil.date_sdf.format(new Date()));
            reqVo.setEndDate(DateUtil.date_sdf.format(new Date()));
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(Calendar.DATE, -1);
            Date d = c.getTime();
            reqVo.setThanStartDate(DateUtil.date_sdf.format(d));
            reqVo.setThanEndDate(DateUtil.date_sdf.format(d));
        }
        //查询客户数量
        BigDecimal customerNumber = BigDecimal.valueOf(mdmTerminalMapper.countTerminalByPosition(reqVo.getPosCode(), reqVo.getEndDate(), MdmBpmStatusEnum.PASS.getValue()))
                .add(BigDecimal.valueOf(mdmCustomerMsgMapper.countCustomerByPosition(reqVo.getPosCode(), reqVo.getEndDate(), MdmBpmStatusEnum.PASS.getValue())));
        if (null == customerNumber) {
            customerNumber = BigDecimal.ZERO;
        }
        mdmCustomerCountRespVo.setCustomerNumber(customerNumber);
        //上期客户数量
        BigDecimal thanCustNumber = BigDecimal.valueOf(mdmTerminalMapper.countTerminalByPosition(reqVo.getPosCode(), reqVo.getThanEndDate(), MdmBpmStatusEnum.PASS.getValue()))
                .add(BigDecimal.valueOf(mdmCustomerMsgMapper.countCustomerByPosition(reqVo.getPosCode(), reqVo.getThanEndDate(), MdmBpmStatusEnum.PASS.getValue())));
        if (null == thanCustNumber) {
            thanCustNumber = BigDecimal.ZERO;
        }
        mdmCustomerCountRespVo.setThanCustNumber(thanCustNumber);
        //客户数增量
        BigDecimal fluctuateNumber = customerNumber.subtract(thanCustNumber);
        mdmCustomerCountRespVo.setFluctuateNumber(fluctuateNumber);
        Result<MdmCustomerCountRespVo> result = sfaVisitDealerDetailFeign.findVisitNumber(reqVo);
        if (result.isSuccess() && null != result.getResult()) {
            MdmCustomerCountRespVo respVo = result.getResult();
            //查询计划拜访数
            mdmCustomerCountRespVo.setPlanVisitNumber(respVo.getPlanVisitNumber());
            //查询实际拜访数
            mdmCustomerCountRespVo.setActualVisitNumber(respVo.getActualVisitNumber());
            //计划完成率
            mdmCustomerCountRespVo.setVisitCompletionRate(respVo.getVisitCompletionRate());
            //查询下单数
            mdmCustomerCountRespVo.setPlaceOrderNumber(respVo.getPlaceOrderNumber());
            //销售达成率
            mdmCustomerCountRespVo.setSalesReachRate(respVo.getSalesReachRate());
            //查询当前时间段被拜访过的客户数
            mdmCustomerCountRespVo.setVisitCustNumber(respVo.getVisitCustNumber());
            //计算拜访覆盖率
            BigDecimal visitCoverRate = BigDecimal.ZERO;
            if (!BigDecimal.ZERO.equals(customerNumber)) {
                visitCoverRate = (mdmCustomerCountRespVo.getVisitCustNumber().compareTo(BigDecimal.ZERO) > 0 ? mdmCustomerCountRespVo.getVisitCustNumber().divide(customerNumber, 4, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100").setScale(2)) : BigDecimal.ZERO);
            }
            mdmCustomerCountRespVo.setVisitCoverRate(visitCoverRate);
            //查询总拜访数量（计划和临时）
            mdmCustomerCountRespVo.setVisitTotalNumber(respVo.getVisitTotalNumber());
        }
        return mdmCustomerCountRespVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void submit(MdmCustomerMsgReqVo reqVo) {
        Assert.hasText(reqVo.getId(), "id不能为空");
        Assert.hasText(reqVo.getWorkFlowKey(), "请选择流程");
        MdmCustomerEntity entity = this.getById(reqVo.getId());
        if (!ApprovalType.BPM.getValue().equals(entity.getApprovalType())) {
            throw new BusinessException("该条数据不能发起流程审批");
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(entity.getActApproveStatus())) {
            throw new BusinessException("审批通过的数据不能发起流程");
        }
        if (MdmBpmStatusEnum.APPROVAL.getValue().equals(entity.getActApproveStatus())) {
            throw new BusinessException("审批中的数据不能发起流程");
        }

        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("MdmCustomerCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setFormType(StringUtils.isNotEmpty(reqVo.getFromType()) ? reqVo.getFromType() : "MDM");
        startProcessReqVo.setCostType("customer");
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getCustomerCode());
        startProcessReqVo.setFileList(reqVo.getActivityFileList());
        String processNo = ActivityUtils.startProcess(startProcessReqVo);
        entity.setProcessCode(processNo);
        entity.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void callback(ActivitiCallBackVo reqVo) {
        MdmCustomerEntity entity = this.getById(reqVo.getFormNo());
        boolean sendMq = false;
        //审批通过
        if (Indicator.CON_BPM_DOING.getCode() == reqVo.getProcessState()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            sendMq = true;
        }
        //审批驳回
        if (Indicator.CON_BPM_PASS.getCode() == reqVo.getProcessState()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
        }
        //流程追回
        if (Indicator.CON_BPM_REJECT.getCode() == reqVo.getProcessState()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.RECOVER.getValue());
        }
        this.updateById(entity);
        if (sendMq) {
            sendCustomerChangeMsg(Collections.singletonList(entity.getCustomerCode()));
            sendAchievementMsg(entity.getCustomerCode(), entity.getFromType());
            MdmCustomerMsgRespVo query = query(reqVo.getFormNo(), null);
            MdmCustomerMsgReqVo copy = CrmBeanUtil.copy(query, MdmCustomerMsgReqVo.class);
            copy.setMdmCustomerDockingVos(CrmBeanUtil.copyList(query.getMdmCustomerDockingVos(), MdmCustomerDockingReqVo.class));
            copy.setMdmCustomerContactVos(CrmBeanUtil.copyList(query.getMdmCustomerContactVos(), MdmCustomerContactReqVo.class));
            elasticsearchService.add(copy);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void statusApprovalSubmit(List<String> ids) {
        Assert.notEmpty(ids, "空参数");
        List<MdmCustomerEntity> list = this.lambdaQuery()
                .in(MdmCustomerEntity::getId, ids)
                .list();
        Assert.notEmpty(list, "无效的id");
        list.forEach(x -> {
            Assert.isTrue(ApprovalType.STATUS.getValue().equals(x.getApprovalType()), "该数据不能提交状态审批");
            Assert.isTrue(!MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), "审批中的数据不能提交状态审批");
            Assert.isTrue(!MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus()), "审批通过的数据不能提交状态审批");
            x.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        });
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void statusApprovalReject(List<String> ids) {
        Assert.notEmpty(ids, "空参数");
        List<MdmCustomerEntity> list = this.lambdaQuery()
                .in(MdmCustomerEntity::getId, ids)
                .list();
        Assert.notEmpty(list, "无效的id");
        list.forEach(x -> {
            Assert.isTrue(ApprovalType.STATUS.getValue().equals(x.getApprovalType()), "该数据不能提交状态审批");
            Assert.isTrue(MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), "审批中的数据才能驳回");
            x.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
        });
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void statusApprovalAgree(List<String> ids) {
        Assert.notEmpty(ids, "空参数");
        List<MdmCustomerEntity> list = this.lambdaQuery()
                .in(MdmCustomerEntity::getId, ids)
                .list();
        Assert.notEmpty(list, "无效的id");
        list.forEach(x -> {
            Assert.isTrue(ApprovalType.STATUS.getValue().equals(x.getApprovalType()), "该数据不能提交状态审批");
            Assert.isTrue(MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), "审批中的数据才能通过");
            x.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        });
        this.updateBatchById(list);
    }

    public void getWeekOfDate(MdmCustomerCountReqVo reqVo) {
        String[] weeks = {"7", "1", "2", "3", "4", "5", "6"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int week_index = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        String week = weeks[week_index];
        int days = 0;
        if ("1".equals(week)) {
            days = 0;
        } else if ("2".equals(week)) {
            days = -1;
        } else if ("3".equals(week)) {
            days = -2;
        } else if ("4".equals(week)) {
            days = -3;
        } else if ("5".equals(week)) {
            days = -4;
        } else if ("6".equals(week)) {
            days = -5;
        } else if ("7".equals(week)) {
            days = -6;
        }
        cal.add(Calendar.DATE, days);
        Date start = cal.getTime();
        reqVo.setStartDate(DateUtil.date_sdf.format(start));
        cal.add(Calendar.DATE, 6);
        Date end = cal.getTime();
        reqVo.setEndDate(DateUtil.date_sdf.format(end));

        cal.add(Calendar.DATE, -7);
        Date thanEnd = cal.getTime();
        reqVo.setThanEndDate(DateUtil.date_sdf.format(thanEnd));
        cal.add(Calendar.DATE, -6);
        Date thanStart = cal.getTime();
        reqVo.setThanStartDate(DateUtil.date_sdf.format(thanStart));
    }

    @Override
    public List<MdmTerminalStatisticianTypeVo> statisticalType(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List<MdmTerminalStatisticianTypeVo> statisticalType = mdmCustomerMsgMapper.statisticalType(mdmCustomerMsgReqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(statisticalType)) {
            Map<String, String> terminalType = DictUtil.dictMap("customer_type");
            return statisticalType.stream()
                    .filter(x -> terminalType.containsKey(x.getStatisticianType()))
                    .peek(x -> {
                        x.setStatisticianName(terminalType.get(x.getStatisticianType()));
                    }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void sendAchievementMsg(String clientCode, String fromType) {
        ArrayList<String> list = Lists.newArrayList();
        list.add(clientCode);
        list.add(fromType);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.INSERT_CLIENT_TAG);
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonStringNotEmptyVal(list));
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCustomerByCustomerOrgCodeList(List<String> customerOrgCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customerOrgCodeList)) {
            List<String> list = CustomerOrgUtil.getChildrenCustomerOrgCodeListIncludeSelfEnable(customerOrgCodeList.stream().filter(x -> StringUtils.isNotEmpty(x)).distinct().collect(Collectors.toList()));
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                List<MdmCustomerEntity> entityList = this.lambdaQuery()
                        .eq(MdmCustomerEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                        .eq(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                        .in(MdmCustomerEntity::getCustomerOrgCode, list)
                        .list();
                if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                    return CrmBeanUtil.copyList(entityList, MdmCustomerMsgRespVo.class);
                }
            }
        }
        return new ArrayList<>();
    }

    /**
     * 客户信息变更发送事件
     *
     * @param vo
     */
    private void customerChangeSendEvent(CustomerChangeHandlerReqVo vo) {
        applicationContext.publishEvent(new CustomerChangeEvent(vo));
    }
    @Override
    public List<MdmCustomerMsgRespVo> queryByCustomerCodeList(List<String> customerCodeList) {
        List<MdmCustomerMsgRespVo> mdmCustomerMsgRespVos = new ArrayList<>();
        if(CollectionUtil.listEmpty(customerCodeList)){
            return mdmCustomerMsgRespVos;
        }
        List<MdmCustomerEntity> mdmCustomerEntityList = this.list(Wrappers.lambdaQuery(MdmCustomerEntity.class).in(MdmCustomerEntity::getCustomerCode, customerCodeList));
        if(CollectionUtil.listNotEmpty(mdmCustomerEntityList)){
             mdmCustomerMsgRespVos = CrmBeanUtil.copyList(mdmCustomerEntityList, MdmCustomerMsgRespVo.class);
            mdmCustomerMsgRespVos.forEach(item->{
                // 联系人信息
                List<MdmCustomerContactEntity> list = mdmCustomerContactService.list(Wrappers.lambdaQuery(MdmCustomerContactEntity.class).eq(MdmCustomerContactEntity::getCustomerCode, item.getCustomerCode()));
                List<MdmCustomerContactRespVo> mdmCustomerContactRespVos = CrmBeanUtil.copyList(list, MdmCustomerContactRespVo.class);
                item.setMdmCustomerContactVos(mdmCustomerContactRespVos);

                // 对接人列表
                MdmCustomerDockingReqVo dockingReqVo = new MdmCustomerDockingReqVo();
                dockingReqVo.setCustomerCode(item.getCustomerCode());
                List<MdmCustomerDockingRespVo> dockingList = mdmCustomerSupplyMapper.findDockingListByCustomerCode(dockingReqVo);
                item.setMdmCustomerDockingVos(dockingList);

                // 组织名称
                MdmOrgRespVo mdmOrgRespVo = mdmOrgService.queryByOrgCode(item.getOrgCode());
                if(mdmOrgRespVo!=null){
                    item.setOrgName(mdmOrgRespVo.getOrgName());
                }

                //客户组织名称
                item.setCustomerOrgName(mdmCusOrgService.lambdaQuery().eq(MdmCusOrgEntity::getCustomerOrgCode,item.getCustomerOrgCode()).one().getCustomerOrgName());
            });
        }
        return mdmCustomerMsgRespVos;
    }

}
