package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.MdmCustomerSaleAreaMapper;
import com.biz.crm.customer.model.MdmCustomerSaleAreaEntity;
import com.biz.crm.customer.service.MdmCustomerSaleAreaService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 客户信息销售区域接口实现
 *
 * @author zxw
 * @date 2020-11-16 15:50:20
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="MdmCustomerSaleAreaServiceExpandImpl")
public class MdmCustomerSaleAreaServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<MdmCustomerSaleAreaMapper, MdmCustomerSaleAreaEntity> implements MdmCustomerSaleAreaService {

    @Resource
    private MdmCustomerSaleAreaMapper mdmCustomerSaleAreaMapper;

    @Override
    public void remove(String customerCode) {
        this.lambdaUpdate()
                .eq(MdmCustomerSaleAreaEntity::getCustomerCode, customerCode)
                .remove();
    }

    @Override
    public void add(List<MdmCustomerSaleAreaEntity> list) {
        this.saveBatch(list);
    }

    @Override
    public List<MdmCustomerSaleAreaRespVo> listCondition(MdmCustomerSaleAreaReqVo mdmCustomerSaleAreaReqVo) {
        List<MdmCustomerSaleAreaRespVo> mdmCustomerSaleAreaRespVos = mdmCustomerSaleAreaMapper.listCondition(mdmCustomerSaleAreaReqVo);
        if(!CollectionUtils.isEmpty(mdmCustomerSaleAreaRespVos)){
            mdmCustomerSaleAreaRespVos=mdmCustomerSaleAreaRespVos.stream().peek(x -> {
                if (StringUtils.isEmpty(x.getAreaOneName())) {
                    x.setAreaOne(null);
                }
                if (StringUtils.isEmpty(x.getAreaTwoName())) {
                    x.setAreaTwo(null);
                }
                if (StringUtils.isEmpty(x.getAreaThreeName())) {
                    x.setAreaThree(null);
                }
            }).collect(Collectors.toList());
        }
        return mdmCustomerSaleAreaRespVos;
    }

    @Override
    public void setUpArea(List<MdmCustomerSaleAreaReqVo> mdmCustomerSaleAreaReqVos, String customerCode) {
        remove(customerCode);
        if (!CollectionUtils.isEmpty(mdmCustomerSaleAreaReqVos)) {
            //过滤一级区域为空的数据
            List<MdmCustomerSaleAreaReqVo> collect = mdmCustomerSaleAreaReqVos.stream().filter(item -> !StringUtils.isEmpty(item.getAreaOne())).peek(x -> x.setCustomerCode(customerCode)).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(collect)) {
                List<MdmCustomerSaleAreaEntity> mdmCustomerSaleAreaEntities = CrmBeanUtil.copyList(collect, MdmCustomerSaleAreaEntity.class);
                this.add(mdmCustomerSaleAreaEntities);
            }
        }
    }
}
