package com.biz.crm.customer.service.impl;


import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerTerminalService;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 接口实现
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmCustomerTerminalServiceExpandImpl")
public class MdmCustomerTerminalServiceImpl implements MdmCustomerTerminalService {

    @Autowired
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmTerminalService mdmTerminalService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void unbind(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        mdmTerminalSupplyService.unbind(mdmCustomerCorrelatedTerminalReqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void replaceCustomer(MdmCustomerCorrelatedTerminalReplaceReqVo mdmCustomerCorrelatedTerminalReplaceReqVo) {
        mdmTerminalSupplyService.replaceCustomer(mdmCustomerCorrelatedTerminalReplaceReqVo);
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> correlatedCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return mdmTerminalSupplyService.correlatedCustomerPage(mdmCustomerTerminalReqVo);
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> unCorrelatedAnyCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return mdmTerminalSupplyService.unCorrelatedAnyCustomerPage(mdmCustomerTerminalReqVo);
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> unCorrelatedCurrentCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return mdmTerminalSupplyService.unCorrelatedCurrentCustomerPage(mdmCustomerTerminalReqVo);
    }

    @Override
    public void correlatedTerminal(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        mdmTerminalSupplyService.customerRelationTerminal(mdmCustomerCorrelatedTerminalReqVo);
    }

    @Override
    public List<MdmCustomerTerminalFuzzyQueryVo> findCustomerTerminalFuzzyList(MdmCustomerTerminalFuzzyQueryVo reqVo) {
        List<MdmCustomerTerminalFuzzyQueryVo> list = new ArrayList<>();
        if (reqVo.getType() == null || MdmCustomerTerminalFuzzyQueryVo.Type.CUSTOMER == reqVo.getType()) {
            List<MdmCustomerEntity> customerList = mdmCustomerMsgService.lambdaQuery()
                    .eq(MdmCustomerEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                    .eq(StringUtils.isNotEmpty(reqVo.getEnableStatus()), MdmCustomerEntity::getEnableStatus, reqVo.getEnableStatus())
                    .like(StringUtils.isNotEmpty(reqVo.getCode()), MdmCustomerEntity::getCustomerCode, reqVo.getCode())
                    .like(StringUtils.isNotEmpty(reqVo.getName()), MdmCustomerEntity::getCustomerName, reqVo.getName())
                    .select(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName, MdmCustomerEntity::getEnableStatus)
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(customerList)) {
                list.addAll(customerList.stream().map(x -> {
                    MdmCustomerTerminalFuzzyQueryVo fuzzyQueryVo = new MdmCustomerTerminalFuzzyQueryVo();
                    fuzzyQueryVo.setCode(x.getCustomerCode());
                    fuzzyQueryVo.setName(x.getCustomerName());
                    fuzzyQueryVo.setEnableStatus(x.getEnableStatus());
                    fuzzyQueryVo.setType(MdmCustomerTerminalFuzzyQueryVo.Type.CUSTOMER);
                    return fuzzyQueryVo;
                }).collect(Collectors.toList()));
            }
        }
        if (reqVo.getType() == null || MdmCustomerTerminalFuzzyQueryVo.Type.TERMINAL == reqVo.getType()) {
            List<MdmTerminalEntity> terminalList = mdmTerminalService.lambdaQuery()
                    .eq(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                    .eq(StringUtils.isNotEmpty(reqVo.getEnableStatus()), MdmTerminalEntity::getEnableStatus, reqVo.getEnableStatus())
                    .like(StringUtils.isNotEmpty(reqVo.getCode()), MdmTerminalEntity::getTerminalCode, reqVo.getCode())
                    .like(StringUtils.isNotEmpty(reqVo.getName()), MdmTerminalEntity::getTerminalName, reqVo.getName())
                    .select(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getTerminalName, MdmTerminalEntity::getEnableStatus)
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(terminalList)) {
                list.addAll(terminalList.stream().map(x -> {
                    MdmCustomerTerminalFuzzyQueryVo fuzzyQueryVo = new MdmCustomerTerminalFuzzyQueryVo();
                    fuzzyQueryVo.setCode(x.getTerminalCode());
                    fuzzyQueryVo.setName(x.getTerminalName());
                    fuzzyQueryVo.setEnableStatus(x.getEnableStatus());
                    fuzzyQueryVo.setType(MdmCustomerTerminalFuzzyQueryVo.Type.TERMINAL);
                    return fuzzyQueryVo;
                }).collect(Collectors.toList()));
            }
        }
        return list;
    }

}
