package com.biz.crm.customermaterial.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.customermaterial.req.MdmCustomerMaterialReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2021-01-06 16:34
 **/
public class MdmCustomerMaterialProvider {

    public String findListProvider(Map<String,Object> map){
        MdmCustomerMaterialReqVo vo = (MdmCustomerMaterialReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){{
            SELECT("a.*,b.material_name,c.customer_org_name");
            FROM("mdm_customer_material a");
            JOIN("mdm_material b on a.material_code=b.material_code");
            JOIN("mdm_cus_org c on c.customer_org_code=a.customer_org_code");
            if(StringUtils.isNotEmpty(vo.getCustomerOrgCode())){
                WHERE("a.customer_org_code like " + ProviderUtil.bindPercent(vo.getCustomerOrgCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getCustomerOrgName())){
                WHERE("c.customer_org_name like "+ProviderUtil.bindPercent(vo.getCustomerOrgName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getMaterialName())){
                WHERE("b.material_name like "+ProviderUtil.bindPercent(vo.getMaterialName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getDelFlag())){
                WHERE("a.del_flag =#{vo.delFlag}");
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("create_date desc,create_date_second desc");
        }}.toString();


    }

}
