package com.biz.crm.customermaterial.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.customermaterial.model.MdmCustomerMaterialEntity;
import com.biz.crm.nebular.mdm.customermaterial.req.MdmCustomerMaterialReqVo;
import com.biz.crm.nebular.mdm.customermaterial.resp.MdmCustomerMaterialRespVo;

/**
 * 客户物料接口
 *
 * @author huang.long
 * @date 2020-09-03 10:26:02
 */
public interface IMdmCustomerMaterialService extends IService<MdmCustomerMaterialEntity> {

    /**
     * 列表
     * @param mdmCustomerMaterialReqVo vo
     * @return PageResult<MdmCustomerMaterialRespVo>
     */
    PageResult<MdmCustomerMaterialRespVo> findList(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 查询
     * @param id id
     * @return MdmCustomerMaterialRespVo
     */
    MdmCustomerMaterialRespVo query(String id);

    /**
     * 新增
     * @param mdmCustomerMaterialReqVo
     * @return
     */
    void save(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 更新
     * @param mdmCustomerMaterialReqVo
     * @return
     */
    void update(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 删除
     * @param mdmCustomerMaterialReqVo
     * @return
     */
    void deleteBatch(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 启用
     * @param mdmCustomerMaterialReqVo
     * @return
     */
    void enableBatch(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 禁用
     * @param mdmCustomerMaterialReqVo
     * @return
     */
    void disableBatch(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);
}

